/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve;

import ix.icore.Status;
import ix.icore.Variable;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.iserve.IServe;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.List;
import javax.servlet.http.HttpServlet;

public class AddServletHandler
extends ActivityHandler {
    private Symbol ADD_SERVLET = Symbol.intern("add-servlet");
    private IServe iserve;

    public AddServletHandler(IServe iServe) {
        super("Add a servlet");
        this.iserve = iServe;
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((add-servlet ?class-name (?parameter ...) ?pathSpec))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() == 4 && lList.get(0) == this.ADD_SERVLET;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new HandlerAction.AutomaticWhenBound(agendaItem, this));
    }

    public void handle(AgendaItem agendaItem) {
        LList lList = (LList)Variable.removeVars(agendaItem.getPattern());
        Symbol symbol = Util.mustBe(Symbol.class, lList.get(1));
        List list = Util.mustBe(List.class, lList.get(2));
        String string = Util.mustBe(String.class, lList.get(3));
        try {
            Class<?> clazz = Class.forName(symbol.toString());
            Object obj = Util.makeInstance(clazz, list.toArray());
            HttpServlet httpServlet = Util.mustBe(HttpServlet.class, obj);
            this.iserve.getHttpServer().addServlet(httpServlet, string);
        }
        catch (Exception exception) {
            throw new RethrownException(exception);
        }
        agendaItem.setStatus(Status.COMPLETE);
    }
}

