/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve;

import ix.ip2.Ip2;
import ix.iserve.AddServletHandler;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.http.HttpServer;
import java.util.List;

public class IServe
extends Ip2 {
    protected HttpServer server;
    protected Thread serverThread;

    public IServe() {
        super(true);
        this.agentTypeName = "I-X Server";
        this.logoLine1 = "I-Serve";
        this.displayName = "I-Serve";
        this.showOptions = false;
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("I-Serve");
        Debug.noteThreads = true;
        System.setProperty("java.net.preferIPv4Stack", "true");
        new IServe().mainStartup(stringArray);
    }

    public synchronized HttpServer getHttpServer() {
        return this.server;
    }

    public void startup() {
        int n = Parameters.getInt("http-server-port", 8080);
        this.server = this.makeHttpServer(n);
        this.configureServer(this.server);
        Debug.noteln("Starting", (Object)this.server);
        this.server.start();
        super.startup();
    }

    protected HttpServer makeHttpServer(int n) {
        return new HttpServer(n);
    }

    protected void configureServer(HttpServer httpServer) {
        String string = Parameters.getParameter("http-root-directory");
        if (string != null) {
            httpServer.parseDocRoot(string, "files");
        }
        httpServer.setLogPath("logs", this.getAgentSymbolName());
    }

    public void addAboutInfo(List list) {
        list.add("");
        list.add("I-Serve is running an HTTP server on port " + this.server.getServerPort());
        list.add("Its document root is " + this.server.getDocRoot());
        list.add("URLs of the form");
        list.add("   " + this.server.getBaseUrl() + this.server.getDocPath() + "/");
        list.add("will be mapped to files in that directory.");
    }

    protected void addHandlers() {
        super.addHandlers();
        this.controller.addActivityHandler(new AddServletHandler(this));
    }
}

