/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.icore.IXAgentExtension;
import ix.iface.util.HtmlStringWriter;
import ix.iface.util.HtmlWriter;
import ix.iserve.IServe;
import ix.iserve.ipc.MessageMemory;
import ix.iserve.ipc.MessageWrapper;
import ix.iserve.ipc.Registration;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Duration;
import ix.util.MessageQueue;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.Util;
import ix.util.http.HttpObjectServlet;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpServer;
import ix.util.http.HttpStringServlet;
import ix.util.http.HttpUtilities;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IServeCommServer
implements IXAgentExtension {
    private HttpServer httpServer;
    private final HttpUtilities httpUtil = new HttpUtilities();
    private final IdentityCheckerFactory defaultIdentityCheckerFactory = new DefaultIdentityCheckerFactory();
    private final IdentityCheckerFactory ixIdentityCheckerFactory = new IXIdentityCheckerFactory();
    private final Date startupDate = new Date();
    private final IServe iserve;
    private final int max_waiting_messages_to_list_in_status = 6;
    private final Thread[] accessibleThreads = new Thread[100];
    protected final Map<String, User> userNameToUserMap = new TreeMap<String, User>();

    public IServeCommServer() {
        this(null);
    }

    public IServeCommServer(IServe iServe) {
        this.iserve = iServe;
    }

    @Override
    public synchronized void installExtension() {
        this.httpServer = this.iserve.getHttpServer();
        Debug.expect(this.httpServer != null, "No HTTP server");
        this.processCommandLineArguments();
        this.addServlets();
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("IServe Message Server");
        IServeCommServer.do_main(stringArray, IServeCommServer.class);
    }

    protected static void do_main(String[] stringArray, Class<? extends IServeCommServer> clazz) {
        Parameters.setIsInteractive(false);
        Parameters.processCommandLineArguments(stringArray);
        Debug.noteThreads = true;
        IServeCommServer iServeCommServer = null;
        try {
            iServeCommServer = Util.makeInstance(clazz);
            iServeCommServer.start();
        }
        catch (Throwable throwable) {
            Debug.noteException(throwable);
            System.exit(1);
        }
        if (Parameters.isInteractive()) {
            while (true) {
                Util.askLine("Server:");
                System.out.println(iServeCommServer.makeServerStatus());
                System.out.println(iServeCommServer.describeAccessibleThreads());
                System.out.println("");
            }
        }
    }

    protected void start() {
        this.processCommandLineArguments();
        int n = this.getListenPort();
        this.httpServer = new HttpServer(n);
        String string = Parameters.getParameter("http-root-directory");
        if (string != null) {
            this.httpServer.parseDocRoot(string, "files");
        }
        String string2 = this.getName();
        this.httpServer.setLogPath("logs", string2);
        this.addServlets();
        this.httpServer.start();
    }

    protected int getListenPort() {
        String string = Parameters.getParameter("ipc-server-pointer");
        if (string != null) {
            URI uRI = this.httpUtil.followServerPointer(string);
            int n = uRI.getPort();
            return n == -1 ? 80 : n;
        }
        return Parameters.getInt("http-server-port", 0);
    }

    protected String getName() {
        if (this.iserve != null && this.iserve.getAgentSymbolName() != null) {
            return this.iserve.getAgentSymbolName();
        }
        for (String string : Arrays.asList("log-name", "symbol-name", "ipc-name")) {
            if (!Parameters.haveParameter(string)) continue;
            return Parameters.getParameter(string);
        }
        return "ix-comm-server";
    }

    protected void processCommandLineArguments() {
    }

    protected void addServlets() {
        this.addServlet(new RegistrationServlet(), "/ipc/ix/register");
        this.addServlet(new SendServlet(), "/ipc/ix/send");
        this.addServlet(new NextMessageServlet(), "/ipc/ix/get-next");
        this.addServlet(new StatusServlet(), "/ipc/status");
        this.addServlet(new ControlServlet(), "/ipc/control");
    }

    protected void addServlet(HttpServlet httpServlet, String string) {
        this.httpServer.addServlet(httpServlet, string);
    }

    protected void fillInRequestInfo(MessageWrapper messageWrapper, HttpServletRequest httpServletRequest) throws HttpRequestException {
        messageWrapper.setRemoteAddr(httpServletRequest.getRemoteAddr());
        messageWrapper.setRemoteHost(httpServletRequest.getRemoteHost());
        if (messageWrapper.getFrom() == null) {
            throw new HttpRequestException(400, "Missing the name of the sending agent.");
        }
    }

    protected void requireCommand(Command command, MessageWrapper messageWrapper) throws HttpRequestException {
        if (messageWrapper.getCommand() == null) {
            throw new HttpRequestException(400, "No command; expected " + (Object)((Object)command));
        }
        if (!messageWrapper.getCommand().equals(command.text())) {
            throw new HttpRequestException(400, "Wrong command " + messageWrapper.getCommand() + "; expected " + command.text());
        }
    }

    protected String makeServerStatus() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Date date = new Date();
        linkedList.add("Status as of " + date);
        linkedList.add("Started running " + this.agoTime(this.startupDate, date));
        List<User> list = this.getUsers();
        if (list.isEmpty()) {
            linkedList.add("No users");
        } else {
            linkedList.add("");
            linkedList.add("Users:");
            for (User user : list) {
                linkedList.add(user.status(date));
                linkedList.add("");
            }
        }
        linkedList.add(Thread.activeCount() + " active threads.");
        return Strings.joinLines(linkedList);
    }

    protected String agoTime(Date date, Date date2) {
        Duration duration = new Duration(date, date2).roundToMinutes();
        return date + (duration.asMilliseconds() > 0L ? ", " + duration + " ago" : "");
    }

    private void noteAccessibleThreads() {
        Debug.noteln(this.describeAccessibleThreads());
    }

    private String describeAccessibleThreads() {
        int n = Thread.enumerate(this.accessibleThreads);
        if (n >= this.accessibleThreads.length) {
            throw new ConsistencyException("too many threads: " + n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(" threads: ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.accessibleThreads[i].getName());
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User ensureIXUser(String string) {
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            User user = this.getUser(string);
            if (user == null) {
                user = new User(string);
                this.recordUser(user);
            }
            user.setIdentityChecker(this.ixIdentityCheckerFactory);
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User ensureUser(String string) {
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            User user = this.getUser(string);
            if (user == null) {
                user = new User(string);
                user.setIdentityChecker(this.defaultIdentityCheckerFactory);
                this.recordUser(user);
            }
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUser(String string) {
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            return this.userNameToUserMap.get(string);
        }
    }

    protected User requireUser(String string) {
        User user = this.getUser(string);
        if (user == null) {
            throw new IllegalStateException("There is no user named " + Strings.quote(string));
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<User> getUsers() {
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            return new LinkedList<User>(this.userNameToUserMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordUser(User user) {
        user.noteln("Recording user");
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            String string = user.getName();
            Debug.expect(this.getUser(string) == null, "User " + string + " already exists");
            this.userNameToUserMap.put(string, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUser(String string) {
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            this.removeUser(this.requireUser(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUser(User user) {
        user.noteln("Removing user");
        Map<String, User> map = this.userNameToUserMap;
        synchronized (map) {
            User user2 = user;
            synchronized (user2) {
                user.deleted();
                this.userNameToUserMap.remove(user.getName());
            }
        }
    }

    protected class IXIdentityChecker
    extends IdentityChecker {
        IXIdentityChecker(User user) {
            super(user);
        }

        public void changingIdentityCheckerFrom(IdentityChecker identityChecker) {
            if (!(identityChecker instanceof DefaultIdentityChecker)) {
                throw new IllegalIdentityCheckerChange(this.user, identityChecker, this);
            }
        }
    }

    protected class DefaultIdentityChecker
    extends IdentityChecker {
        DefaultIdentityChecker(User user) {
            super(user);
        }

        protected void checkMessageSource(MessageWrapper messageWrapper) {
            throw new IllegalStateException("The default identity-checker should not be in force once an agent has sent something to the server.  The user involved is " + this.user);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class IdentityChecker {
        protected final User user;
        protected String password;
        protected String hostName;
        protected String hostAddr;

        protected IdentityChecker(User user) {
            this.user = user;
        }

        public void changingIdentityCheckerFrom(IdentityChecker identityChecker) {
            throw new IllegalIdentityCheckerChange(this.user, identityChecker, this);
        }

        public void init() {
        }

        public void checkRegisterRequest(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checkMessagePassword(messageWrapper);
            if (this.hostAddr == null) {
                this.hostAddr = messageWrapper.getRemoteAddr();
                this.hostName = messageWrapper.getRemoteHost();
                this.user.noteln("Host is " + this.hostName + " " + this.hostAddr);
            } else if (!this.hostAddr.equals(messageWrapper.getRemoteAddr())) {
                this.hostAddr = messageWrapper.getRemoteAddr();
                this.hostName = messageWrapper.getRemoteHost();
                this.user.noteln("Host is now" + this.hostName + " " + this.hostAddr);
            }
            this.user.assignUUID();
        }

        public void checkSendRequest(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checkMessageSource(messageWrapper);
        }

        public void checkAddMessage(MessageWrapper messageWrapper) {
        }

        public void checkNextMessageRequest(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checkMessageSource(messageWrapper);
        }

        public void status(Date date, List<String> list) {
        }

        protected void checkMessageSource(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checkMessageHost(messageWrapper);
            this.checkMessageUUID(messageWrapper);
        }

        protected void checkMessageHost(MessageWrapper messageWrapper) throws HttpRequestException {
            if (this.hostAddr == null) {
                throw new ConsistencyException(this.user + " has no host addr");
            }
            if (messageWrapper.getRemoteAddr() == null) {
                throw new ConsistencyException("Failed to attach host addr to message for " + this.user);
            }
            if (!this.hostAddr.equals(messageWrapper.getRemoteAddr())) {
                throw new HttpRequestException(403, "Wrong host");
            }
        }

        protected void checkMessageUUID(MessageWrapper messageWrapper) throws HttpRequestException {
            String string = this.user.getUUID();
            if (string == null) {
                throw new ConsistencyException(this.user + " has no UUID.");
            }
            if (messageWrapper.getUUID() == null) {
                throw new HttpRequestException(403, "Missing UUID");
            }
            if (!string.equals(messageWrapper.getUUID())) {
                throw new HttpRequestException(403, "Wrong UUID");
            }
        }

        protected void checkMessagePassword(MessageWrapper messageWrapper) throws HttpRequestException {
            if (this.password == null) {
                if (messageWrapper.getPassword() != null) {
                    this.password = messageWrapper.getPassword();
                    this.user.noteln("Set password to", this.password);
                }
            } else if (messageWrapper.getPassword() != null && !this.password.equals(messageWrapper.getPassword())) {
                throw new HttpRequestException(403, "Invalid password");
            }
        }
    }

    public class IllegalIdentityCheckerChange
    extends IllegalStateException {
        public IllegalIdentityCheckerChange(User user, IdentityChecker identityChecker, IdentityChecker identityChecker2) {
            super("Illegal identity-checker change for " + user + ": " + "from " + Util.aClass(identityChecker) + " to " + Util.aClass(identityChecker2));
        }
    }

    protected class IXIdentityCheckerFactory
    implements IdentityCheckerFactory {
        protected IXIdentityCheckerFactory() {
        }

        public boolean existingCheckerIsOk(IdentityChecker identityChecker) {
            return identityChecker instanceof IXIdentityChecker;
        }

        public IdentityChecker makeIdentityChecker(User user) {
            return new IXIdentityChecker(user);
        }
    }

    protected class DefaultIdentityCheckerFactory
    implements IdentityCheckerFactory {
        protected DefaultIdentityCheckerFactory() {
        }

        public boolean existingCheckerIsOk(IdentityChecker identityChecker) {
            return identityChecker instanceof IdentityChecker;
        }

        public IdentityChecker makeIdentityChecker(User user) {
            return new DefaultIdentityChecker(user);
        }
    }

    protected static interface IdentityCheckerFactory {
        public boolean existingCheckerIsOk(IdentityChecker var1);

        public IdentityChecker makeIdentityChecker(User var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class User {
        String name;
        String uuid;
        MessageQueue responseQueue = null;
        MessageMemory unacknowledged = new MessageMemory();
        List<Date> registrationDates = new LinkedList<Date>();
        Date lastContactDate = null;
        Date lastSendDate = null;
        Date lastAckDate = null;
        MessageWrapper lastAckdMessage = null;
        boolean haveSentGetNext = false;
        int seqNo = 0;
        IdentityChecker checker;
        Map<Symbol, Object> properties = new TreeMap<Symbol, Object>();

        public User(String string) {
            this.name = string;
        }

        public synchronized void setIdentityChecker(IdentityCheckerFactory identityCheckerFactory) {
            if (this.checker == null || !identityCheckerFactory.existingCheckerIsOk(this.checker)) {
                IdentityChecker identityChecker = identityCheckerFactory.makeIdentityChecker(this);
                this.noteln("Setting id checker to " + identityChecker);
                if (this.checker != null) {
                    identityChecker.changingIdentityCheckerFrom(this.checker);
                }
                this.checker = identityChecker;
                this.checker.init();
            }
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized String getUUID() {
            Debug.expect(this.uuid != null, this + " has no uuid");
            return this.uuid;
        }

        public synchronized void setUUID(String string) {
            this.uuid = string;
        }

        public synchronized void assignUUID() {
            this.setUUID(UUID.randomUUID().toString());
        }

        public synchronized Object getProperty(Symbol symbol) {
            return this.properties.get(symbol);
        }

        public synchronized void setProperty(Symbol symbol, Object object) {
            this.noteln("set-property " + symbol + " = " + object);
            this.properties.put(symbol, object);
        }

        public synchronized Date getLastContactDate() {
            return this.lastContactDate;
        }

        public synchronized List getRegistrationDates() {
            return new ArrayList<Date>(this.registrationDates);
        }

        public synchronized Date getLastSendDate() {
            return this.lastSendDate;
        }

        public synchronized Date getLastAckDate() {
            return this.lastAckDate;
        }

        public synchronized MessageWrapper getLastAckdMessage() {
            return this.lastAckdMessage;
        }

        public synchronized void deleted() {
            if (this.responseQueue != null) {
                this.responseQueue.send(new AbandonRequest());
                this.responseQueue = null;
            }
        }

        public synchronized void clearUnacknowledgedMessages() {
            this.unacknowledged.clear();
        }

        public synchronized void addMessage(MessageWrapper messageWrapper) {
            this.noteln("Adding message " + this.seqNo);
            messageWrapper.setSeqNo(this.seqNo++);
            this.checker.checkAddMessage(messageWrapper);
            this.unacknowledged.remember(messageWrapper);
            this.maybeSendFirstUnacknowledgedMessage();
        }

        public synchronized void register(MessageWrapper messageWrapper) throws HttpRequestException {
            this.noteln(this.registrationDates.isEmpty() ? "new registration" : "re-registration");
            this.checker.checkRegisterRequest(messageWrapper);
            this.maybeFixSequenceNumbers(messageWrapper);
            Date date = this.sent(messageWrapper);
            this.registrationDates.add(date);
        }

        private void maybeFixSequenceNumbers(MessageWrapper messageWrapper) {
            if (messageWrapper.getSequenceNumber() == null) {
                this.noteln("No sequence number in wrapper");
                return;
            }
            int n = messageWrapper.getSeqNo();
            this.noteln("Seq numbers: " + messageWrapper.getCommand() + " request says " + n + ", we have " + this.seqNo);
            if (!this.haveSentGetNext && n > -1) {
                this.noteln("Renumbering messages");
                int n2 = n + 1;
                this.unacknowledged.renumberMessages(n2);
                this.seqNo += n2;
                this.noteln("Revised next-message number " + this.seqNo);
            }
        }

        public synchronized void checkForSend(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checker.checkSendRequest(messageWrapper);
            this.sent(messageWrapper);
        }

        private Date sent(MessageWrapper messageWrapper) {
            Date date;
            this.lastContactDate = date = new Date();
            if (messageWrapper.getCommand().equals("send-to")) {
                this.lastSendDate = date;
            }
            return date;
        }

        public Object nextMessage(MessageWrapper messageWrapper) throws HttpRequestException {
            return this.getResponseQueue(messageWrapper).nextMessage();
        }

        private synchronized MessageQueue getResponseQueue(MessageWrapper messageWrapper) throws HttpRequestException {
            this.noteln("getResponseQueue called");
            this.checker.checkNextMessageRequest(messageWrapper);
            this.maybeFixSequenceNumbers(messageWrapper);
            this.sent(messageWrapper);
            if (messageWrapper.getSequenceNumber() != null) {
                this.acknowledgedReceipt(messageWrapper.getSequenceNumber());
            }
            if (this.responseQueue != null) {
                this.responseQueue.send(new AbandonRequest());
                this.responseQueue = null;
            }
            MessageQueue messageQueue = this.responseQueue = new MessageQueue();
            this.maybeSendFirstUnacknowledgedMessage();
            return messageQueue;
        }

        private void acknowledgedReceipt(Integer n) {
            Date date;
            this.lastContactDate = date = new Date();
            if (this.unacknowledged.containsKey(n)) {
                this.noteln("Acknowledged receipt of message", n);
                this.lastAckDate = date;
                this.lastAckdMessage = this.unacknowledged.getMessage(n);
                this.unacknowledged.forgetKey(n);
            }
        }

        private void maybeSendFirstUnacknowledgedMessage() {
            MessageWrapper messageWrapper;
            if (this.responseQueue != null && (messageWrapper = this.getFirstUnacknowledgedMessage()) != null) {
                this.responseQueue.send(messageWrapper);
                this.responseQueue = null;
                this.haveSentGetNext = true;
            }
        }

        private MessageWrapper getFirstUnacknowledgedMessage() {
            MessageWrapper messageWrapper = this.unacknowledged.getFirstRemainingMessage();
            if (messageWrapper != null) {
                this.noteln("Getting 1st message; it has key", messageWrapper.getSequenceNumber());
            }
            return messageWrapper;
        }

        public void noteln(String string) {
            Debug.noteln(this + ": " + string);
        }

        public void noteln(String string, Object object) {
            Debug.noteln(this + ": " + string, object);
        }

        public synchronized String toString() {
            return "User[" + this.name + "]";
        }

        synchronized String status(Date date) {
            List<Date> list;
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this.name);
            if (this.lastContactDate != null) {
                linkedList.add("  Time of last active contact: " + IServeCommServer.this.agoTime(this.lastContactDate, date));
            }
            if (this.lastSendDate != null) {
                linkedList.add("  Last send to another agent:  " + IServeCommServer.this.agoTime(this.lastSendDate, date));
            }
            if (this.lastAckDate != null) {
                linkedList.add("  Last receipt acknowledgment: " + IServeCommServer.this.agoTime(this.lastAckDate, date));
            }
            if (!(list = this.registrationDates).isEmpty()) {
                linkedList.add("  Registration times:");
                for (Date date2 : list) {
                    linkedList.add("    " + IServeCommServer.this.agoTime(date2, date));
                }
            }
            this.checker.status(date, linkedList);
            if (!this.unacknowledged.isEmpty()) {
                linkedList.add("  Waiting messages:");
                this.addWaitingMessageStatus(linkedList);
            }
            return Strings.joinLines(linkedList);
        }

        private void addWaitingMessageStatus(List<String> list) {
            int n;
            int n2 = this.unacknowledged.size();
            if (n2 <= (n = 6) + 1) {
                for (MessageWrapper messageWrapper : this.unacknowledged) {
                    list.add(this.describeMessage(messageWrapper));
                }
                return;
            }
            int n3 = n / 2;
            int n4 = n2 - n3;
            int n5 = 0;
            for (MessageWrapper messageWrapper : this.unacknowledged) {
                if (n5 == n3) {
                    list.add("... (" + (n2 - n) + " other messages) ...");
                } else if (n5 < n3 || n5 >= n4) {
                    list.add(this.describeMessage(messageWrapper));
                }
                ++n5;
            }
        }

        private String describeMessage(MessageWrapper messageWrapper) {
            Object object = messageWrapper.getContents();
            Class<?> clazz = object.getClass();
            String string = XML.nameForClass(clazz);
            return messageWrapper.getSeqNo() + ": " + messageWrapper.getSendDate() + " " + string + " from " + messageWrapper.getFrom() + ": " + object;
        }
    }

    public static class AbandonRequest
    extends HttpRequestException {
        AbandonRequest() {
            super(202, "Request was superseded.");
        }

        public void printStackTrace(PrintStream printStream) {
        }
    }

    class NextMessageServlet
    extends HttpObjectServlet {
        NextMessageServlet() {
        }

        protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) throws HttpRequestException {
            Debug.noteln("Server received", object);
            MessageWrapper messageWrapper = (MessageWrapper)object;
            IServeCommServer.this.fillInRequestInfo(messageWrapper, httpServletRequest);
            IServeCommServer.this.requireCommand(Command.GET_MESSAGE, messageWrapper);
            Object object2 = IServeCommServer.this.ensureIXUser(messageWrapper.getFrom()).nextMessage(messageWrapper);
            Debug.noteln("NextMessageServlet obtained", object2);
            if (object2 instanceof AbandonRequest) {
                Debug.noteln("Told to abandon request");
                throw (HttpRequestException)object2;
            }
            Debug.noteln("Sending next message to", (Object)messageWrapper.getFrom());
            return object2;
        }
    }

    class SendServlet
    extends HttpObjectServlet {
        SendServlet() {
        }

        protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) throws HttpRequestException {
            Debug.noteln("Server asked to send", object);
            MessageWrapper messageWrapper = (MessageWrapper)object;
            IServeCommServer.this.fillInRequestInfo(messageWrapper, httpServletRequest);
            IServeCommServer.this.requireCommand(Command.SEND_TO, messageWrapper);
            IServeCommServer.this.ensureIXUser(messageWrapper.getFrom()).checkForSend(messageWrapper);
            IServeCommServer.this.ensureUser(messageWrapper.getTo()).addMessage(messageWrapper);
            Debug.noteln("Returning \"OK\"");
            return "OK";
        }
    }

    class RegistrationServlet
    extends HttpObjectServlet {
        RegistrationServlet() {
        }

        protected Object handleRequest(HttpServletRequest httpServletRequest, Object object) throws HttpRequestException {
            Debug.noteln("Server asked to register", object);
            MessageWrapper messageWrapper = (MessageWrapper)object;
            IServeCommServer.this.fillInRequestInfo(messageWrapper, httpServletRequest);
            IServeCommServer.this.requireCommand(Command.REGISTER, messageWrapper);
            User user = IServeCommServer.this.ensureIXUser(messageWrapper.getFrom());
            user.register(messageWrapper);
            Debug.noteln("Returning \"OK\"");
            return Registration.makeSuccess(user.getUUID());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ServerCommand {
        Select_A_Command{

            void eval(HttpServletRequest httpServletRequest, IServeCommServer iServeCommServer) {
            }
        }
        ,
        Delete_User{

            void eval(HttpServletRequest httpServletRequest, IServeCommServer iServeCommServer) {
                for (String string : this.selectedUsers(httpServletRequest)) {
                    iServeCommServer.removeUser(string);
                }
            }
        }
        ,
        Clear_Messages{

            void eval(HttpServletRequest httpServletRequest, IServeCommServer iServeCommServer) {
                for (String string : this.selectedUsers(httpServletRequest)) {
                    iServeCommServer.requireUser(string).clearUnacknowledgedMessages();
                }
            }
        };


        abstract void eval(HttpServletRequest var1, IServeCommServer var2);

        String[] selectedUsers(HttpServletRequest httpServletRequest) {
            String[] stringArray = httpServletRequest.getParameterValues("user");
            return stringArray != null ? stringArray : new String[]{};
        }
    }

    class ControlServlet
    extends HttpStringServlet {
        ControlServlet() {
            this.setResponseContentType("text/html");
        }

        protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            this.doPost(httpServletRequest, httpServletResponse);
        }

        protected String readRequest(HttpServletRequest httpServletRequest) {
            return "";
        }

        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            Object object;
            String string2 = httpServletRequest.getParameter("command");
            Debug.noteln("Server command", (Object)string2);
            if (string2 != null) {
                object = ServerCommand.valueOf(string2);
                ((ServerCommand)((Object)object)).eval(httpServletRequest, IServeCommServer.this);
            }
            object = new HtmlStringWriter();
            Date date = new Date();
            ((HtmlWriter)object).tag("pre");
            ((HtmlWriter)object).writeln("Status as of " + date);
            ((HtmlWriter)object).writeln("Started running " + IServeCommServer.this.agoTime(IServeCommServer.this.startupDate, date));
            ((HtmlWriter)object).end("pre");
            ((HtmlWriter)object).newLine();
            ((HtmlWriter)object).tag("form", new String[][]{{"method", "get"}, {"action", "control"}});
            ((HtmlWriter)object).newLine();
            ((HtmlWriter)object).tag("table");
            for (User user : IServeCommServer.this.getUsers()) {
                String string3 = XML.encodeText(user.getName());
                ((HtmlWriter)object).tag("tr", "valign=\"top\"");
                ((HtmlWriter)object).tag("td");
                ((HtmlWriter)object).empty("input", new String[][]{{"type", "checkbox"}, {"name", "user"}, {"value", string3}});
                ((HtmlWriter)object).end("td");
                ((HtmlWriter)object).newLine();
                ((HtmlWriter)object).tag("td");
                ((HtmlWriter)object).tagged("pre", XML.encodeText(user.status(date)));
                ((HtmlWriter)object).end("td");
                ((HtmlWriter)object).end("tr");
                ((HtmlWriter)object).newLine();
            }
            ((HtmlWriter)object).end("table");
            ((HtmlWriter)object).newLine();
            ((HtmlWriter)object).select("command", ServerCommand.values(), ServerCommand.Select_A_Command);
            ((HtmlWriter)object).newLine();
            ((HtmlWriter)object).empty("input", "type=\"submit\" value=\"Submit\"");
            ((HtmlWriter)object).newLine();
            ((HtmlWriter)object).end("form");
            return ((HtmlStringWriter)object).toString();
        }
    }

    class StatusServlet
    extends HttpServlet {
        StatusServlet() {
        }

        protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(200);
            httpServletResponse.getWriter().println(IServeCommServer.this.makeServerStatus());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Command {
        REGISTER("register"),
        SEND_TO("send-to"),
        GET_MESSAGE("get-message");

        private String text;

        private Command(String string2) {
            this.text = string2;
        }

        public String text() {
            return this.text;
        }
    }
}

