/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.Release;
import ix.icore.Annotated;
import ix.icore.IXAgent;
import ix.iface.util.Reporting;
import ix.iserve.ipc.IServeCommTool;
import ix.iserve.ipc.MessageMemory;
import ix.iserve.ipc.MessageWrapper;
import ix.iserve.ipc.Registration;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.ParameterException;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.RethrownIOException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.http.HttpObjectClient;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpUtilities;
import ix.util.ipc.ServiceAddress;
import ix.util.lisp.Symbol;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;

public class IServeCommStrategy
implements IPC.CommunicationStrategy {
    public static Symbol SEND_DATE = Symbol.intern("send-date");
    protected IPC.MessageListener messageListener;
    protected URI serverBase;
    protected URL sendUrl;
    protected URL nextMessageUrl;
    protected URL registerUrl;
    protected IServeCommTool tool;
    protected ReceiveThread receiveThread = null;
    protected int receiveThreadCount = 0;
    protected boolean ableToSend = false;
    protected String uuid = null;
    protected volatile int expectedSeqNo = 0;
    protected MessageMemory messageMap = new MessageMemory();
    protected HttpObjectClient sendClient = this.makeSendClient();
    protected HttpUtilities httpUtil = new HttpUtilities();

    void setTool(IServeCommTool iServeCommTool) {
        this.tool = iServeCommTool;
    }

    protected String getAgentName() {
        return IXAgent.getAgent().getAgentSymbolName();
    }

    synchronized boolean isAbleToSend() {
        return this.ableToSend;
    }

    synchronized void setIsAbleToSend(boolean bl) {
        this.ableToSend = bl;
    }

    synchronized String getMessageUrlBase() {
        return Strings.beforeLast("/", this.sendUrl.toString());
    }

    public void setupServer(Object object, IPC.MessageListener messageListener) {
        this.messageListener = messageListener;
        this.serverBase = this.determineServerBase();
        Debug.noteln("Comm server base URI", (Object)this.serverBase);
        this.sendUrl = this.httpUtil.makeMessageURL(this.serverBase, "ipc/ix/send");
        this.nextMessageUrl = this.httpUtil.makeMessageURL(this.serverBase, "ipc/ix/get-next");
        this.registerUrl = this.httpUtil.makeMessageURL(this.serverBase, "ipc/ix/register");
        this.sendClient.setReadTimeout(60000);
        this.installCommTool();
    }

    protected void installCommTool() {
        IXAgent iXAgent = IXAgent.getAgent();
        String string = iXAgent.getAgentDisplayName() + " I-Serve Communications";
        IServeCommTool.Controller controller = new IServeCommTool.Controller(this, string);
        iXAgent.addTool(controller);
        controller.ensureTool();
        Debug.expect(this.tool != null);
    }

    protected void initialCommToolTranscript() {
        this.tool.transcript("I-X " + Release.version + " " + Release.date + " " + Release.time);
        this.tool.transcript("Communications base URL: " + this.getMessageUrlBase());
    }

    protected URI determineServerBase() {
        String string = Parameters.getParameter("ipc-server-pointer");
        String string2 = Parameters.getParameter("ipc-server");
        if (string != null) {
            return this.httpUtil.followServerPointer(string);
        }
        if (string2 != null) {
            ServiceAddress serviceAddress = new ServiceAddress(string2);
            return URI.create("http://" + serviceAddress.getHost() + ":" + serviceAddress.getPort() + "/");
        }
        throw new ParameterException("An ipc-server-pointer or ipc-server parameter must be supplied.");
    }

    public void register(String string) {
        Debug.expect(SwingUtilities.isEventDispatchThread(), "not in Swing");
        this.transcript("Trying to register with the comm server.");
        Debug.noteln("Trying to register with password", (Object)string);
        HttpObjectClient httpObjectClient = this.sendClient;
        MessageWrapper messageWrapper = MessageWrapper.makeRegister(this.getAgentName(), string);
        messageWrapper.setSeqNo(this.expectedSeqNo - 1);
        messageWrapper.setSendDate(new Date());
        messageWrapper.setUUID(this.uuid);
        Object object = httpObjectClient.sendRequest(this.registerUrl, messageWrapper);
        Registration registration = Util.mustBe(Registration.class, object);
        if (!registration.isSuccess()) {
            throw new IPC.IPCException("Registration failure: " + registration.getStatus());
        }
        this.uuid = registration.getUUID();
        this.transcript("Registered as " + this.getAgentName() + ", uuid = " + this.uuid);
        this.setIsAbleToSend(true);
        this.ensureReceiving();
    }

    public void sendObject(Object object, Object object2) {
        if (!this.isAbleToSend()) {
            throw new UnsupportedOperationException("Cannot send to " + object + " until you have registered with the message server.");
        }
        MessageWrapper messageWrapper = MessageWrapper.makeSend(this.getAgentName(), (String)object, object2);
        messageWrapper.setSendDate(new Date());
        messageWrapper.setUUID(this.uuid);
        Object object3 = this.sendClient.sendRequest(this.sendUrl, messageWrapper);
        Debug.noteln("Received", object3);
        if (!object3.equals("OK")) {
            throw new IPC.IPCException("Unexpected reply from message-server: " + object3);
        }
    }

    protected HttpObjectClient makeSendClient() {
        return new HttpObjectClient();
    }

    protected HttpObjectClient makeReceiveClient() {
        return new HttpObjectClient();
    }

    synchronized void ensureReceiving() {
        if (this.receiveThread == null) {
            this.startReceiving();
        }
    }

    protected synchronized void startReceiving() {
        this.transcript("Preparing to receive messages.");
        if (this.receiveThread != null) {
            throw new ConsistencyException("Non-null receiveThread");
        }
        this.receiveThread = new ReceiveThread();
        this.receiveThread.start();
    }

    protected synchronized void awaitStartedReceiving() {
        try {
            this.receiveThread.awaitStart();
        }
        catch (InterruptedException interruptedException) {
            throw new RethrownException(interruptedException, "Interrupted while starting receiving.");
        }
    }

    public synchronized void stopReceiving() {
        if (this.receiveThread != null) {
            this.receiveThread.stopRunning();
        }
    }

    protected synchronized void stoppedReceiving() {
        this.transcriptLater("Stopped receiving.");
        this.receiveThread = null;
    }

    protected Object getReceivedContents(MessageWrapper messageWrapper) {
        Object object = messageWrapper.getContents();
        if (object instanceof Annotated && messageWrapper.getSendDate() != null) {
            ((Annotated)object).setAnnotation(SEND_DATE, messageWrapper.getSendDate());
        }
        return object;
    }

    public void reportProblem(String string, Throwable throwable) {
        this.transcript(string + ": " + Debug.describeException(throwable));
        Debug.displayException(string, throwable);
    }

    protected void reportIdentityCheckFailure(HttpRequestException httpRequestException) {
        String[] stringArray = new String[]{"Request refused because it had the wrong host or uuid.", "You will have to re-register."};
        this.transcript(Strings.joinLines(stringArray));
        Util.displayAndWait(null, stringArray);
    }

    public void transcript(final String string) {
        Debug.noteln("Transcript:", (Object)string);
        Util.swingAndWait(new Runnable(){

            public void run() {
                IServeCommStrategy.this.do_transcript(Reporting.dateString() + " " + string);
            }
        });
    }

    public void transcriptLater(final String string) {
        Debug.noteln("Transcript Later:", (Object)string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IServeCommStrategy.this.do_transcript(Reporting.dateString() + " " + string);
            }
        });
    }

    protected void do_transcript(String string) {
        try {
            this.tool.transcript(string);
        }
        catch (Throwable throwable) {
            Debug.displayException("Problem adding transcript line " + Strings.quote(string), throwable);
        }
    }

    class ReceiveThread
    extends Thread {
        final HttpObjectClient receiveClient;
        final String ourName;
        final CountDownLatch started;
        volatile boolean keepRunning;
        MessageWrapper message;

        ReceiveThread() {
            super("I-Serve comm receiver " + IServeCommStrategy.this.receiveThreadCount++);
            this.receiveClient = IServeCommStrategy.this.makeReceiveClient();
            this.ourName = IServeCommStrategy.this.getAgentName();
            this.started = new CountDownLatch(1);
            this.keepRunning = true;
            this.message = null;
            this.setDaemon(true);
        }

        public void awaitStart() throws InterruptedException {
            this.started.await();
        }

        public void stopRunning() {
            this.keepRunning = false;
            this.interrupt();
        }

        public void run() {
            this.started.countDown();
            int n = 0;
            while (this.keepRunning) {
                try {
                    this.message = this.nextMessage(this.message);
                    n = 0;
                }
                catch (RethrownIOException rethrownIOException) {
                    try {
                        throw rethrownIOException.getCause();
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        Debug.noteln("Timeout when requesting next message");
                        continue;
                    }
                    catch (ConnectException connectException) {
                        if (n < 3) {
                            Debug.noteException(connectException, false);
                            ++n;
                            Util.sleepSeconds(10);
                            continue;
                        }
                        IServeCommStrategy.this.reportProblem("Can't connect to server", connectException);
                        break;
                    }
                    catch (SocketException socketException) {
                        String string = socketException.getMessage();
                        if (string.indexOf("end of file") >= 0 || string.startsWith("Connection reset")) {
                            Debug.noteException(socketException, false);
                            continue;
                        }
                        IServeCommStrategy.this.reportProblem("Unexpected", socketException);
                        break;
                    }
                    catch (HttpRequestException httpRequestException) {
                        if (httpRequestException.getStatus() == 202) {
                            Debug.noteException(httpRequestException, false);
                            continue;
                        }
                        if (httpRequestException.getStatus() == 403) {
                            IServeCommStrategy.this.reportIdentityCheckFailure(httpRequestException);
                            break;
                        }
                        IServeCommStrategy.this.reportProblem("Problem when requesting next message", httpRequestException);
                        break;
                    }
                    catch (Throwable throwable) {
                        IServeCommStrategy.this.reportProblem("Problem requesting next message", throwable);
                        break;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    IServeCommStrategy.this.reportProblem("Problem while requesting next message", throwable);
                    break;
                }
                try {
                    this.handleMessage(this.message);
                }
                catch (Throwable throwable) {
                    IServeCommStrategy.this.reportProblem("Problem while handling message", throwable);
                }
            }
            IServeCommStrategy.this.stoppedReceiving();
        }

        MessageWrapper nextMessage(MessageWrapper messageWrapper) {
            Object object;
            MessageWrapper messageWrapper2 = MessageWrapper.makeGetNextMessage(this.ourName);
            messageWrapper2.setUUID(IServeCommStrategy.this.uuid);
            if (messageWrapper != null) {
                messageWrapper2.setSeqNo(messageWrapper.getSeqNo());
            }
            if (!((object = this.receiveClient.sendRequest(IServeCommStrategy.this.nextMessageUrl, messageWrapper2)) instanceof MessageWrapper)) {
                throw new ClassCastException("Received an instance of " + object.getClass().getName() + " instead of a MessageWrapper.");
            }
            MessageWrapper messageWrapper3 = (MessageWrapper)object;
            Debug.expect(messageWrapper3.getCommand().equals("send-to"));
            Debug.expect(messageWrapper3.getTo().equals(this.ourName));
            return messageWrapper3;
        }

        void handleMessage(MessageWrapper messageWrapper) {
            Integer n = messageWrapper.getSequenceNumber();
            int n2 = messageWrapper.getSeqNo();
            Debug.expect(n2 == n);
            if (n2 == IServeCommStrategy.this.expectedSeqNo) {
                Debug.expect(!IServeCommStrategy.this.messageMap.containsKey(n));
                ++IServeCommStrategy.this.expectedSeqNo;
            } else if (n2 > IServeCommStrategy.this.expectedSeqNo) {
                Debug.noteln("Missing messages between " + IServeCommStrategy.this.expectedSeqNo + " and " + n2);
                IServeCommStrategy.this.expectedSeqNo = n2 + 1;
            } else {
                Debug.expect(n2 < IServeCommStrategy.this.expectedSeqNo);
                if (IServeCommStrategy.this.messageMap.containsKey(n)) {
                    IServeCommStrategy.this.transcript("Received " + n2 + " again");
                    return;
                }
                Debug.noteln("Received gap message", n2);
            }
            Object object = IServeCommStrategy.this.getReceivedContents(messageWrapper);
            IServeCommStrategy.this.transcript("Received " + n2 + ": " + Reporting.description(object));
            IServeCommStrategy.this.messageMap.remember(messageWrapper);
            IServeCommStrategy.this.messageListener.messageReceived(new IPC.BasicInputMessage(object));
        }
    }
}

