/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.iface.util.ToolController;
import ix.iserve.ipc.IServeCommStrategy;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.Util;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;

public class IServeCommTool {
    IServeCommStrategy strategy;
    ToolFrame frame;

    public IServeCommTool(IServeCommStrategy iServeCommStrategy, String string) {
        this.strategy = iServeCommStrategy;
        iServeCommStrategy.setTool(this);
        this.frame = new ToolFrame(string);
        iServeCommStrategy.initialCommToolTranscript();
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void register() {
        String string = this.strategy.getAgentName();
        String string2 = Util.showInputDialog(this.frame, "Enter a password for " + string, string);
        if (string2 == null) {
            this.frame.registerButton.setEnabled(true);
            return;
        }
        try {
            this.strategy.register(string2);
        }
        catch (Exception exception) {
            Debug.displayException(exception);
        }
    }

    void needToReregister() {
        Util.displayAndWait(this.frame, new String[]{"This agent is unable to connect to the server needed", "for inter-agent communications, probably because the server", "has exited.  You will need to re-register when a server", "is again available.  Some messages may have been lost."});
        this.frame.registerButton.setEnabled(true);
    }

    public void transcript(String string) {
        this.frame.appendLine(string);
    }

    public static class Controller
    extends ToolController {
        IServeCommStrategy strategy;
        String title;

        public Controller(IServeCommStrategy iServeCommStrategy, String string) {
            super("I-Serve Communications");
            this.strategy = iServeCommStrategy;
            this.title = string;
        }

        protected Object createTool() {
            return new IServeCommTool(this.strategy, this.title);
        }
    }

    protected class ToolFrame
    extends TextAreaFrame {
        JButton registerButton;

        ToolFrame(String string) {
            super(0, 0, string, new String[0]);
            this.setEditable(false);
            this.addListener(new ToolTListener());
        }

        protected void finishFrame() {
            this.frame.pack();
            this.frame.setSize(400, 200);
            this.frame.validate();
        }

        public void clearText() {
            this.setText("");
            IServeCommTool.this.strategy.initialCommToolTranscript();
        }

        protected TextAreaFrame.TFrame makeTFrame(String string, String[] stringArray) {
            return new ToolTFrame(string, stringArray);
        }

        class ToolTListener
        implements TextAreaFrame.TListener {
            ToolTListener() {
            }

            public void buttonPressed(String string) {
                if (string.equals("Register")) {
                    IServeCommTool.this.register();
                } else {
                    Debug.noteln("ToolTListener ignores", (Object)string);
                }
            }
        }

        class ToolTFrame
        extends TextAreaFrame.TFrame {
            ToolTFrame(String string, String[] stringArray) {
                super(string, stringArray);
                this.contentPane.add((Component)this.makeButtonPanel(), "South");
            }

            protected JPanel makeButtonPanel() {
                JPanel jPanel = new JPanel();
                ToolFrame.this.registerButton = this.makeButton("Register");
                jPanel.add(ToolFrame.this.registerButton);
                return jPanel;
            }
        }
    }
}

