/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.Annotated;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.Variable;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.util.Debug;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;
import java.util.List;
import java.util.ListIterator;

public class LinearIXSyntax {
    private String from = "";

    public LinearIXSyntax(String string) {
        this.from = string;
    }

    public String encode(Sendable sendable) {
        if (sendable instanceof Activity) {
            return this.encode((Activity)sendable);
        }
        if (sendable instanceof ChatMessage) {
            return this.encode((ChatMessage)sendable);
        }
        throw new UnsupportedOperationException("Can't yet encode " + sendable);
    }

    public String encode(Activity activity) {
        LList lList = (LList)Variable.removeVars(activity.getPattern());
        String string = PatternParser.unparse(lList);
        activity.ensureId();
        return "A" + activity.getId() + "^" + this.senderId(activity) + "^" + string;
    }

    public String encode(ChatMessage chatMessage) {
        return "M^" + this.string(this.senderId(chatMessage)) + "^" + this.string(chatMessage.getText());
    }

    private String string(Object object) {
        return object == null ? "" : object.toString();
    }

    private String senderId(Sendable sendable) {
        return sendable.getSenderId() != null ? sendable.getSenderId().toString() : this.from;
    }

    public Sendable decode(String string) {
        if (!string.equals("")) {
            switch (string.charAt(0)) {
                case 'A': {
                    return this.decodeActivity(string);
                }
                case 'C': {
                    return this.decodeConstraint(string);
                }
                case 'R': {
                    return this.decodeReport(string);
                }
                case 'M': {
                    return this.decodeChatMessage(string);
                }
            }
        }
        throw new IllegalArgumentException("Cannot decode " + Strings.quote(string));
    }

    public Activity decodeActivity(String string) {
        String[] stringArray = this.breakup(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        LList lList = PatternParser.parse(string4);
        Activity activity = new Activity(lList);
        this.setTo(activity, string3);
        activity.setRef(Name.valueOf(string2));
        return activity;
    }

    public Constraint decodeConstraint(String string) {
        String[] stringArray = this.breakup(string);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String[] stringArray2 = this.breakup(string3, " ", 3);
        String string4 = stringArray2[0];
        String string5 = stringArray2[1];
        String string6 = stringArray2[2];
        if (string4.equals("state")) {
            string4 = "world-state";
        }
        String[] stringArray3 = Strings.breakAtFirst("=", string6);
        String string7 = stringArray3[0].trim();
        String string8 = stringArray3[1].trim();
        if (string8.equals("")) {
            string8 = "true";
        }
        LList lList = PatternParser.parse(string7);
        Object object = Lisp.readFromString(string8);
        PatternAssignment patternAssignment = new PatternAssignment(lList, object);
        Constraint constraint = new Constraint(string4, string5, (List)Lisp.list(patternAssignment));
        this.setTo(constraint, string2);
        return constraint;
    }

    public Report decodeReport(String string) {
        String[] stringArray = this.breakup(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String[] stringArray2 = this.breakup(string4, " ", 2);
        String string5 = stringArray2[0];
        String string6 = stringArray2[1];
        Report report = new Report();
        this.setTo(report, string3);
        report.setText(string6);
        report.setReportType(ReportType.valueOf(string5));
        report.setRef(Name.valueOf(string2));
        return report;
    }

    public ChatMessage decodeChatMessage(String string) {
        String[] stringArray = this.breakup(string);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        ChatMessage chatMessage = new ChatMessage();
        this.setTo(chatMessage, string2);
        chatMessage.setText(string3);
        return chatMessage;
    }

    private String[] breakup(String string) {
        return this.breakup(string, "^", 3);
    }

    private String[] breakup(String string, String string2, int n) {
        List<String> list = Strings.breakAt(string2, string);
        if (list.size() < n) {
            throw new IllegalArgumentException("Missing fields in " + Strings.quote(string));
        }
        String[] stringArray = new String[n];
        ListIterator<String> listIterator = list.listIterator();
        for (int i = 0; i < n - 1; ++i) {
            stringArray[i] = listIterator.next();
            listIterator.remove();
        }
        stringArray[n - 1] = Strings.joinWith(string2, list);
        return stringArray;
    }

    private String getTo(Sendable sendable) {
        return (String)((Annotated)((Object)sendable)).getAnnotation("to");
    }

    private void setTo(Sendable sendable, String string) {
        ((Annotated)((Object)sendable)).setAnnotation("to", string);
    }

    public static void main(String[] stringArray) {
        String string;
        LinearIXSyntax linearIXSyntax = new LinearIXSyntax("AnAgent");
        while (!(string = Util.askLine("-- ")).equals("bye")) {
            try {
                Sendable sendable = linearIXSyntax.decode(string);
                System.out.println(XML.objectToXMLString(sendable));
                System.out.println(linearIXSyntax.encode(sendable));
            }
            catch (Exception exception) {
                System.out.println(Debug.describeException(exception));
            }
        }
    }
}

