/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc;

import ix.iserve.ipc.MessageWrapper;
import ix.util.Debug;
import ix.util.Proc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageMemory
implements Iterable<MessageWrapper> {
    protected final SortedMap<Integer, MessageWrapper> seqNoToMessageMap = new TreeMap<Integer, MessageWrapper>();

    public int size() {
        return this.seqNoToMessageMap.size();
    }

    public boolean isEmpty() {
        return this.seqNoToMessageMap.isEmpty();
    }

    public void clear() {
        this.seqNoToMessageMap.clear();
    }

    public void remember(MessageWrapper messageWrapper) {
        Integer n = messageWrapper.getSequenceNumber();
        Debug.expect(!this.seqNoToMessageMap.containsKey(n));
        this.seqNoToMessageMap.put(n, messageWrapper);
    }

    public void forget(MessageWrapper messageWrapper) {
        this.forgetKey(messageWrapper.getSequenceNumber());
    }

    public void forgetKey(Integer n) {
        Debug.expect(this.seqNoToMessageMap.containsKey(n));
        this.seqNoToMessageMap.remove(n);
    }

    public boolean containsKey(Object object) {
        return this.seqNoToMessageMap.containsKey(object);
    }

    public MessageWrapper getMessage(Integer n) {
        return (MessageWrapper)this.seqNoToMessageMap.get(n);
    }

    public Integer firstKey() {
        return this.seqNoToMessageMap.firstKey();
    }

    public Integer lastKey() {
        return this.seqNoToMessageMap.lastKey();
    }

    public MessageWrapper getFirstRemainingMessage() {
        return this.seqNoToMessageMap.isEmpty() ? null : (MessageWrapper)this.seqNoToMessageMap.get(this.seqNoToMessageMap.firstKey());
    }

    public void renumberMessages(int n) {
        ArrayList<MessageWrapper> arrayList = new ArrayList<MessageWrapper>(this.seqNoToMessageMap.values());
        this.seqNoToMessageMap.clear();
        for (MessageWrapper messageWrapper : arrayList) {
            int n2 = messageWrapper.getSeqNo();
            int n3 = n2 + n;
            Debug.noteln("renumbering " + n2 + " to " + n3);
            messageWrapper.setSeqNo(n3);
            this.remember(messageWrapper);
        }
    }

    public void walkContents(Proc proc) {
        for (Map.Entry<Integer, MessageWrapper> entry : this.seqNoToMessageMap.entrySet()) {
            proc.call(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Iterator<MessageWrapper> iterator() {
        return this.seqNoToMessageMap.values().iterator();
    }
}

