/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc.sl;

import ix.ichat.ChatMessage;
import ix.icore.Activity;
import ix.icore.Annotated;
import ix.icore.Issue;
import ix.icore.Report;
import ix.iserve.IServe;
import ix.iserve.ipc.IServeCommServer;
import ix.iserve.ipc.MessageWrapper;
import ix.iserve.ipc.sl.SLHttpHeader;
import ix.iserve.ipc.sl.SLReplyDecoder;
import ix.iserve.ipc.sl.SLRpc;
import ix.iserve.ipc.sl.SLRpcMessage;
import ix.iserve.ipc.sl.WorldTable;
import ix.test.LongToBytes;
import ix.test.xml.VirtualWorld;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.PatternParser;
import ix.util.PropertyLogger;
import ix.util.Strings;
import ix.util.Util;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpStringServlet;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;

public class IServeSLCommServer
extends IServeCommServer {
    final List<SLHttpHeader> headerProperties = Lisp.list((Object)SLHttpHeader.XSL_OBJECT_NAME, (Object)SLHttpHeader.XSL_OBJECT_KEY, (Object)SLHttpHeader.XSL_REGION, (Object)SLHttpHeader.XSL_OWNER_NAME, (Object)SLHttpHeader.XSL_OWNER_KEY);
    private final IServeCommServer.IdentityCheckerFactory slIdentityCheckerFactory = new SLIdentityCheckerFactory();
    private final WorldTable worlds = new WorldTable();
    private PropertyLogger propertyLogger;
    private static final Symbol LAST_WAKEUP_DATE = Symbol.intern("last-wakeup-date");
    private static final Symbol XML_RPC_CHANNEL = Symbol.intern("xml-rpc-channel");
    private static final Symbol VIRTUAL_WORLD = Symbol.intern("virtual-world");
    ExecutorService wakeupPool = Executors.newFixedThreadPool(3);
    SLRpc rpcClient = new SLRpc();

    public IServeSLCommServer() {
    }

    public IServeSLCommServer(IServe iServe) {
        super(iServe);
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("IServe Message Server");
        IServeSLCommServer.do_main(stringArray, IServeSLCommServer.class);
    }

    protected void processCommandLineArguments() {
        super.processCommandLineArguments();
        String string = Parameters.getParameter("virtual-worlds");
        if (string != null) {
            for (Object e : XML.readObject(List.class, string)) {
                this.worlds.add(Util.mustBe(VirtualWorld.class, e));
            }
        }
        String string2 = "logs/" + this.getName() + "-properties";
        this.propertyLogger = new PropertyLogger(string2);
        this.propertyLogger.readLogIfExists();
    }

    protected void addServlets() {
        super.addServlets();
        this.addServlet(new SLRegistrationServelt(), "/ipc/sl/register");
        this.addServlet(new SLSendServlet(), "/ipc/sl/send");
        this.addServlet(new SLNextMessageServlet(), "/ipc/sl/get-next");
        this.addServlet(new SLChatbotTestServlet(), "/ipc/sl/chat");
        this.addServlet(new SLReplyServlet(), "/ipc/sl/reply");
    }

    protected MessageWrapper makeMessageWrapper(IServeCommServer.Command command, HttpServletRequest httpServletRequest) throws HttpRequestException {
        MessageWrapper messageWrapper = new MessageWrapper();
        messageWrapper.setCommand(command.text());
        messageWrapper.setFrom(SLHttpHeader.XSL_OBJECT_NAME.requireHeader(httpServletRequest));
        this.fillInRequestInfo(messageWrapper, httpServletRequest);
        for (SLHttpHeader sLHttpHeader : this.headerProperties) {
            String string = sLHttpHeader.getHeader(httpServletRequest);
            if (string == null || string.indexOf("Loading...") >= 0) continue;
            this.setHeaderAnnotation(messageWrapper, sLHttpHeader, string);
        }
        VirtualWorld virtualWorld = this.worlds.findWorld(httpServletRequest);
        if (virtualWorld != null) {
            messageWrapper.setAnnotation(VIRTUAL_WORLD, virtualWorld);
        }
        return messageWrapper;
    }

    protected void setHeaderAnnotation(MessageWrapper messageWrapper, SLHttpHeader sLHttpHeader, String string) {
        messageWrapper.setAnnotation(sLHttpHeader.text(), string);
    }

    protected String getHeaderAnnotation(MessageWrapper messageWrapper, SLHttpHeader sLHttpHeader) {
        return (String)messageWrapper.getAnnotation(sLHttpHeader.text());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IServeCommServer.User ensureSLUser(String string) {
        IServeCommServer.User user;
        Object object = this.userNameToUserMap;
        synchronized (object) {
            user = this.getUser(string);
            if (user == null) {
                user = new IServeCommServer.User(this, string);
                this.recordUser(user);
            }
        }
        object = user;
        synchronized (object) {
            long l;
            long l2;
            long l3;
            user.setIdentityChecker(this.slIdentityCheckerFactory);
            Date date = user.getLastContactDate();
            if (date != null && (l3 = (l2 = (l = System.currentTimeMillis()) - date.getTime())) < 1000L) {
                try {
                    Thread.sleep(1000L - l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return user;
        }
    }

    private Date getLastWakeupDate(IServeCommServer.User user) {
        return (Date)user.getProperty(LAST_WAKEUP_DATE);
    }

    private void setLastWakeupDate(IServeCommServer.User user, Date date) {
        user.setProperty(LAST_WAKEUP_DATE, date);
    }

    private String getWakeupChannel(IServeCommServer.User user) {
        String string = (String)user.getProperty(XML_RPC_CHANNEL);
        return string != null ? string : this.propertyLogger.get(XML_RPC_CHANNEL.toString(), user.getName());
    }

    private void setWakeupChannel(IServeCommServer.User user, String string) {
        user.setProperty(XML_RPC_CHANNEL, string);
        this.propertyLogger.putIfNew(XML_RPC_CHANNEL.toString(), user.getName(), string);
    }

    private VirtualWorld getVirtualWorld(Annotated annotated) {
        return (VirtualWorld)annotated.getAnnotation(VIRTUAL_WORLD);
    }

    private VirtualWorld getVirtualWorld(IServeCommServer.User user) {
        VirtualWorld virtualWorld = (VirtualWorld)user.getProperty(VIRTUAL_WORLD);
        if (virtualWorld != null) {
            return virtualWorld;
        }
        String string = this.propertyLogger.get(VIRTUAL_WORLD.toString(), user.getName());
        if (string != null) {
            return this.worlds.worldNamed(string);
        }
        return null;
    }

    private void setVirtualWorld(IServeCommServer.User user, VirtualWorld virtualWorld) {
        user.setProperty(VIRTUAL_WORLD, virtualWorld);
        this.propertyLogger.putIfNew(VIRTUAL_WORLD.toString(), user.getName(), virtualWorld.getName());
    }

    void maybeSendWakeup(IServeCommServer.User user) {
        if (user.getLastContactDate() == null) {
            return;
        }
        Date date = user.getLastAckDate();
        Date date2 = user.getLastSendDate();
        Date date3 = new Date();
        if (date == null && date2 == null) {
            this.tryToWakeup(user, date3);
            return;
        }
        Date date4 = date == null ? date2 : (date2 == null ? date : (date.compareTo(date2) > 0 ? date : date2));
        long l = date3.getTime() - date4.getTime();
        if (l >= 120000L) {
            this.tryToWakeup(user, date3);
        }
    }

    void tryToWakeup(IServeCommServer.User user, Date date) {
        Date date2 = this.getLastWakeupDate(user);
        if (date2 != null && date.getTime() - date2.getTime() < 60000L) {
            user.noteln("Skipping wakeup because we've recently sent one.");
            return;
        }
        VirtualWorld virtualWorld = this.getVirtualWorld(user);
        if (virtualWorld == null) {
            user.noteln("Skipping wakeup because we don't know the world.");
            return;
        }
        if (virtualWorld.getXmlRpcUrl() == null) {
            user.noteln("Skipping wakeup because we don't know the URL.");
            return;
        }
        if (this.getWakeupChannel(user) == null) {
            user.noteln("Skipping wakeup because we don't have a channel id.");
            return;
        }
        Debug.noteln("Decided to try to wake up", (Object)user);
        this.setLastWakeupDate(user, date);
        this.wakeupPool.execute(new Awakener(user));
    }

    class Awakener
    implements Runnable {
        IServeCommServer.User user;

        Awakener(IServeCommServer.User user) {
            this.user = user;
        }

        public void run() {
            Debug.noteln("Trying to wake up", (Object)this.user);
            URL uRL = IServeSLCommServer.this.getVirtualWorld(this.user).getXmlRpcUrl();
            String string = IServeSLCommServer.this.getWakeupChannel(this.user);
            try {
                SLRpcMessage sLRpcMessage = IServeSLCommServer.this.rpcClient.sendRequest(uRL, string, 0, "Wake up");
                Debug.noteln("Wakeup reply from " + this.user + ": " + sLRpcMessage);
            }
            catch (Exception exception) {
                Debug.noteln("Problem while trying to wake up", (Object)this.user);
                Debug.noteException(exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SLIdentityChecker
    extends IServeCommServer.IdentityChecker {
        protected String ownerKey;
        protected String ownerName;

        SLIdentityChecker(IServeCommServer.User user) {
            super(IServeSLCommServer.this, user);
            this.ownerKey = null;
            this.ownerName = null;
        }

        @Override
        public void changingIdentityCheckerFrom(IServeCommServer.IdentityChecker identityChecker) {
            this.user.noteln("Changing identity-checker from " + identityChecker + " to " + this);
        }

        @Override
        public void init() {
        }

        @Override
        public void checkRegisterRequest(MessageWrapper messageWrapper) throws HttpRequestException {
            this.checkMessageSource(messageWrapper);
            String string = (String)messageWrapper.getContents();
            IServeSLCommServer.this.setWakeupChannel(this.user, string);
        }

        @Override
        public void checkAddMessage(MessageWrapper messageWrapper) {
            IServeSLCommServer.this.maybeSendWakeup(this.user);
        }

        @Override
        public void status(Date date, List<String> list) {
            VirtualWorld virtualWorld;
            Date date2 = IServeSLCommServer.this.getLastWakeupDate(this.user);
            if (date2 != null) {
                list.add("  Last wakeup call: " + IServeSLCommServer.this.agoTime(date2, date));
            }
            if (IServeSLCommServer.this.getWakeupChannel(this.user) == null) {
                list.add("  No wakeup channel");
            }
            if ((virtualWorld = IServeSLCommServer.this.getVirtualWorld(this.user)) != null) {
                list.add("  World: " + virtualWorld.getName());
            }
            if (this.ownerName != null) {
                list.add("  Owner name: " + this.ownerName);
            }
        }

        @Override
        protected void checkMessageSource(MessageWrapper messageWrapper) throws HttpRequestException {
            String string = IServeSLCommServer.this.getHeaderAnnotation(messageWrapper, SLHttpHeader.XSL_OWNER_KEY);
            String string2 = IServeSLCommServer.this.getHeaderAnnotation(messageWrapper, SLHttpHeader.XSL_OWNER_NAME);
            if (this.ownerKey == null) {
                this.user.noteln("Recording owner key", string);
                this.ownerKey = string;
            } else if (!string.equals(this.ownerKey)) {
                this.user.noteln("Changing owner key to", string);
                this.ownerKey = string;
            }
            if (this.ownerName == null) {
                this.user.noteln("Recording owner name", string2);
                this.ownerName = string2;
            } else if (string2 != null && !string2.equals(this.ownerName)) {
                this.user.noteln("Changing owner name to", string2);
                this.ownerName = string2;
            }
            this.checkMessageWorld(messageWrapper);
        }

        protected void real_checkMessageSource(MessageWrapper messageWrapper) throws HttpRequestException {
            String string = IServeSLCommServer.this.getHeaderAnnotation(messageWrapper, SLHttpHeader.XSL_OWNER_KEY);
            String string2 = IServeSLCommServer.this.getHeaderAnnotation(messageWrapper, SLHttpHeader.XSL_OWNER_NAME);
            if (this.ownerKey == null) {
                this.user.noteln("Recording owner key", string);
                this.ownerKey = string;
            } else if (!string.equals(this.ownerKey)) {
                throw new HttpRequestException(403, "Wrong owner key");
            }
            if (this.ownerName == null) {
                this.user.noteln("Recording owner name", string2);
                this.ownerName = string2;
            }
            this.checkMessageWorld(messageWrapper);
        }

        private void checkMessageWorld(MessageWrapper messageWrapper) {
            VirtualWorld virtualWorld = IServeSLCommServer.this.getVirtualWorld(messageWrapper);
            if (virtualWorld == null) {
                this.user.noteln("Could not find virtual world");
            } else {
                VirtualWorld virtualWorld2 = IServeSLCommServer.this.getVirtualWorld(this.user);
                if (virtualWorld2 == null) {
                    IServeSLCommServer.this.setVirtualWorld(this.user, virtualWorld);
                } else if (virtualWorld2 != virtualWorld) {
                    this.user.noteln("Changing world from " + virtualWorld2 + " to " + virtualWorld);
                    IServeSLCommServer.this.setVirtualWorld(this.user, virtualWorld);
                }
            }
        }
    }

    protected class SLIdentityCheckerFactory
    implements IServeCommServer.IdentityCheckerFactory {
        protected SLIdentityCheckerFactory() {
        }

        public boolean existingCheckerIsOk(IServeCommServer.IdentityChecker identityChecker) {
            return identityChecker instanceof SLIdentityChecker;
        }

        public IServeCommServer.IdentityChecker makeIdentityChecker(IServeCommServer.User user) {
            return new SLIdentityChecker(user);
        }
    }

    class SLReplyServlet
    extends HttpStringServlet {
        SLReplyDecoder decoder = new SLReplyDecoder();

        SLReplyServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            IServeCommServer.User user;
            MessageWrapper messageWrapper = IServeSLCommServer.this.makeMessageWrapper(IServeCommServer.Command.SEND_TO, httpServletRequest);
            messageWrapper.setSendDate(new Date());
            IServeCommServer.User user2 = user = IServeSLCommServer.this.ensureSLUser(messageWrapper.getFrom());
            synchronized (user2) {
                user.checkForSend(messageWrapper);
                MessageWrapper messageWrapper2 = user.getLastAckdMessage();
                try {
                    this.decoder.fillInReply(messageWrapper, string, messageWrapper2);
                }
                catch (Exception exception) {
                    throw new HttpRequestException(400, Debug.describeException(exception));
                }
            }
            IServeSLCommServer.this.ensureUser(messageWrapper.getTo()).addMessage(messageWrapper);
            return "OK";
        }
    }

    class SLChatbotTestServlet
    extends HttpStringServlet {
        SLChatbotTestServlet() {
        }

        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            MessageWrapper messageWrapper = IServeSLCommServer.this.makeMessageWrapper(IServeCommServer.Command.SEND_TO, httpServletRequest);
            messageWrapper.setSendDate(new Date());
            ChatMessage chatMessage = new ChatMessage(string, messageWrapper.getFrom());
            messageWrapper.setContents(chatMessage);
            messageWrapper.setTo("chat-service");
            IServeSLCommServer.this.ensureSLUser(messageWrapper.getFrom()).checkForSend(messageWrapper);
            IServeSLCommServer.this.ensureUser(messageWrapper.getTo()).addMessage(messageWrapper);
            return "OK";
        }
    }

    class SLNextMessageServlet
    extends HttpStringServlet {
        SLNextMessageServlet() {
        }

        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            MessageWrapper messageWrapper = IServeSLCommServer.this.makeMessageWrapper(IServeCommServer.Command.GET_MESSAGE, httpServletRequest);
            IServeCommServer.User user = IServeSLCommServer.this.ensureSLUser(messageWrapper.getFrom());
            this.setSequenceNunberIfPresent(messageWrapper, string);
            Object object = user.nextMessage(messageWrapper);
            Debug.noteln("SLNextMessageServlet obtained", object);
            if (object instanceof IServeCommServer.AbandonRequest) {
                Debug.noteln("Told to abandon request");
                throw (HttpRequestException)object;
            }
            Debug.noteln("Sending next message to", (Object)messageWrapper.getFrom());
            MessageWrapper messageWrapper2 = (MessageWrapper)object;
            String string2 = this.encodeForSL(messageWrapper2.getContents());
            long l = messageWrapper2.getSequenceNumber().longValue();
            String string3 = LongToBytes.encode(l);
            string2 = string3 + "^" + string2;
            Debug.noteln("Will send " + user, (Object)string2);
            return string2;
        }

        void setSequenceNunberIfPresent(MessageWrapper messageWrapper, String string) {
            if (string.startsWith("Received ")) {
                String string2 = Strings.afterFirst("Received ", string);
                long l = LongToBytes.decode(string2);
                messageWrapper.setSeqNo((int)l);
            }
        }

        String encodeForSL(Object object) {
            if (object instanceof ChatMessage) {
                return ((ChatMessage)object).getText();
            }
            if (object instanceof Activity) {
                return PatternParser.unparse(((Activity)object).getPattern());
            }
            if (object instanceof Issue) {
                return PatternParser.unparse(((Issue)object).getPattern());
            }
            if (object instanceof Report) {
                return ((Report)object).getText();
            }
            throw new IllegalArgumentException("Can't encode for SL: " + object);
        }
    }

    class SLSendServlet
    extends HttpStringServlet {
        SLSendServlet() {
        }

        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            MessageWrapper messageWrapper = IServeSLCommServer.this.makeMessageWrapper(IServeCommServer.Command.SEND_TO, httpServletRequest);
            IServeSLCommServer.this.ensureSLUser(messageWrapper.getFrom()).checkForSend(messageWrapper);
            IServeSLCommServer.this.ensureUser(messageWrapper.getTo()).addMessage(messageWrapper);
            return "OK";
        }
    }

    class SLRegistrationServelt
    extends HttpStringServlet {
        SLRegistrationServelt() {
        }

        protected String handleRequest(HttpServletRequest httpServletRequest, String string) throws HttpRequestException {
            MessageWrapper messageWrapper = IServeSLCommServer.this.makeMessageWrapper(IServeCommServer.Command.REGISTER, httpServletRequest);
            messageWrapper.setContents(string);
            IServeSLCommServer.this.ensureSLUser(messageWrapper.getFrom()).register(messageWrapper);
            return "OK";
        }
    }
}

