/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc.sl;

import ix.icore.Activity;
import ix.icore.Report;
import ix.icore.ReportType;
import ix.icore.Sendable;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iserve.ipc.MessageWrapper;
import ix.util.Name;
import ix.util.PatternParser;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;
import ix.util.match.SimpleMatcher;
import java.util.List;

public class SLReplyDecoder {
    String PROGRESS_REPORT = "activity progressing";
    String COMPLETION_REPORT = "activity completed";
    String INFORMATION_REPORT = "activity information";
    String STARTED_ACTIVITY = "activity started";
    String STOPPED_ACTIVITY = "activity stopped";
    String STATE_CONSTRAINT = "state-constraint";
    Symbol Q_ATTRIBUTE = Symbol.intern("?attribute");
    Symbol Q_OBJECT = Symbol.intern("?object");
    Symbol Q_VALUE = Symbol.intern("?value");
    PatternParser.LispPatternParser lpp = new PatternParser.LispPatternParser();
    LList CONSTRAINT_PATTERN = this.lpp.parsePattern("state-constraint ?attribute ?object = ?value");

    public void fillInReply(MessageWrapper messageWrapper, String string, MessageWrapper messageWrapper2) {
        Sendable sendable = this.decodeContents(string);
        sendable.setSenderId(Name.valueOf(messageWrapper.getFrom()));
        messageWrapper.setContents(sendable);
        if (messageWrapper2 == null || messageWrapper2.getFrom() == null) {
            messageWrapper.setTo("unknown recipient");
        } else {
            messageWrapper.setTo(messageWrapper2.getFrom());
            if (sendable instanceof Report) {
                this.fillInReport((Report)sendable, messageWrapper2);
            }
        }
    }

    Sendable decodeContents(String string) {
        if (string.startsWith(this.STATE_CONSTRAINT)) {
            return this.decodeConstraint(string);
        }
        return this.decodeReport(string);
    }

    Constraint decodeConstraint(String string) {
        MatchEnv matchEnv = SimpleMatcher.mustMatch(this.CONSTRAINT_PATTERN, this.lpp.parsePattern(string));
        Object v = matchEnv.get(this.Q_ATTRIBUTE);
        Object v2 = matchEnv.get(this.Q_OBJECT);
        Object v3 = matchEnv.get(this.Q_VALUE);
        return new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(Lisp.list(v, v2), v3)));
    }

    Report decodeReport(String string) {
        if (string.equals(this.PROGRESS_REPORT)) {
            return new Report(ReportType.PROGRESS, string);
        }
        if (string.equals(this.COMPLETION_REPORT) || string.equals(this.STARTED_ACTIVITY) || string.equals(this.STOPPED_ACTIVITY)) {
            return new Report(ReportType.SUCCESS, string);
        }
        if (string.startsWith(this.INFORMATION_REPORT + " ")) {
            return new Report(ReportType.INFORMATION, Strings.afterFirst(this.INFORMATION_REPORT + " ", string));
        }
        return new Report(ReportType.PROGRESS, string);
    }

    void fillInReport(Report report, MessageWrapper messageWrapper) {
        Activity activity;
        Object object = messageWrapper.getContents();
        if (object != null && object instanceof Activity && (activity = (Activity)object).getRef() != null) {
            report.setRef(activity.getRef());
        }
    }
}

