/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc.sl;

import ix.iserve.ipc.sl.SLRpcMessage;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.http.HttpStringClient;
import ix.util.xml.XML;
import java.net.URL;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class SLRpc {
    protected String defaultServerURL = "http://xmlrpc.secondlife.com/cgi-bin/xmlrpc.cgi";
    protected HttpStringClient http = this.makeHttpStringClient();

    public SLRpc() {
        this.defaultServerURL = Parameters.getParameter("sl-xmlrpc-server", this.defaultServerURL);
    }

    protected HttpStringClient makeHttpStringClient() {
        HttpStringClient httpStringClient = new HttpStringClient();
        httpStringClient.setRequestContentType("application/xml");
        httpStringClient.setConnectTimeout(60000);
        httpStringClient.setReadTimeout(30000);
        return httpStringClient;
    }

    public SLRpcMessage sendRequest(String string, int n, String string2) {
        return this.sendRequest(XML.toURL(this.defaultServerURL), string, n, string2);
    }

    public SLRpcMessage sendRequest(URL uRL, String string, int n, String string2) {
        Debug.noteln("Sending XML-RCP to", (Object)uRL);
        String string3 = this.makeCallString(string, n, string2);
        String string4 = this.http.sendRequest(uRL, string3);
        return this.decodeResponse(string4);
    }

    public String makeCallString(String string, int n, String string2) {
        SLRpcMessage sLRpcMessage = new SLRpcMessage(string, n, string2);
        Element element = this.makeCall(sLRpcMessage);
        Document document = new Document(element);
        return XML.documentToXMLString(document);
    }

    private Element makeCall(SLRpcMessage sLRpcMessage) {
        Element element = new Element("methodCall");
        element.addContent((Content)new Element("methodName").setText("llRemoteData"));
        element.addContent((Content)new Element("params").addContent((Content)new Element("param").addContent((Content)new Element("value").addContent((Content)this.makeStruct(sLRpcMessage)))));
        return element;
    }

    private Element makeStruct(SLRpcMessage sLRpcMessage) {
        Element element = new Element("struct");
        element.addContent((Content)this.makeField("Channel", sLRpcMessage.getChannel()));
        element.addContent((Content)this.makeField("IntValue", sLRpcMessage.getIntValue()));
        element.addContent((Content)this.makeField("StringValue", sLRpcMessage.getStringValue()));
        return element;
    }

    private Element makeField(String string, Object object) {
        Element element = new Element("member");
        element.addContent((Content)new Element("name").setText(string));
        element.addContent((Content)new Element("value").addContent((Content)new Element(this.typeTag(object)).setText(object.toString())));
        return element;
    }

    private String typeTag(Object object) {
        if (object instanceof Integer || object instanceof Long) {
            return "int";
        }
        if (object instanceof String) {
            return "string";
        }
        throw new IllegalArgumentException("Cannot determine a type tag for " + object);
    }

    public SLRpcMessage decodeResponse(String string) {
        ElementFilter elementFilter;
        Document document = XML.parseXML(string);
        Element element = document.getRootElement();
        Element element2 = element.getChild("params");
        Element element3 = element2.getChild("param");
        Element element4 = element3.getChild("value");
        Iterator iterator = element4.getDescendants((Filter)(elementFilter = new ElementFilter("struct")));
        if (iterator.hasNext()) {
            Element element5 = (Element)iterator.next();
            Debug.expectEquals("struct", element5.getName());
            return this.decodeMessageStruct(element5);
        }
        throw new IllegalArgumentException("Missing struct in " + string);
    }

    private SLRpcMessage decodeMessageStruct(Element element) {
        String string = (String)this.getFieldValue(element, "Channel", "");
        Integer n = (Integer)this.getFieldValue(element, "IntValue", 0);
        String string2 = (String)this.getFieldValue(element, "StringValue", "");
        return new SLRpcMessage(string, n, string2);
    }

    private Object getFieldValue(Element element, String string, Object object) {
        for (Element element2 : element.getChildren()) {
            Element element3 = element2.getChild("name");
            if (!element3.getText().equals(string)) continue;
            Element element4 = element2.getChild("value");
            Element element5 = (Element)element4.getChildren().get(0);
            String string2 = element5.getName();
            String string3 = element5.getText();
            return this.unstringValue(string2, string3);
        }
        return object;
    }

    private Object unstringValue(String string, String string2) {
        if (string.equals("int") || string.equals("i4")) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RethrownException(numberFormatException);
            }
        }
        if (string.equals("string")) {
            return string2;
        }
        throw new IllegalArgumentException("Unknown type tag " + string);
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.requireParameter("to");
        String string2 = Parameters.requireParameter("channel");
        String string3 = Parameters.requireParameter("string");
        int n = Parameters.getInt("int", 0);
        URL uRL = XML.toURL(string);
        SLRpc sLRpc = new SLRpc();
        String string4 = sLRpc.makeCallString(string2, n, string3);
        HttpStringClient httpStringClient = sLRpc.makeHttpStringClient();
        httpStringClient.setConnectTimeout(60000);
        httpStringClient.setReadTimeout(30000);
        String string5 = httpStringClient.sendRequest(uRL, string4);
        System.out.println(string5);
        System.out.println(sLRpc.decodeResponse(string5));
    }
}

