/*
 * Decompiled with CFR 0.152.
 */
package ix.iserve.ipc.sl;

import ix.iserve.ipc.sl.SLHttpHeader;
import ix.test.xml.VirtualWorld;
import ix.util.Debug;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WorldTable {
    private Map<String, VirtualWorld> nameToWorld = new LinkedHashMap<String, VirtualWorld>();
    private Map<String, VirtualWorld> shardToWorldCache = new LinkedHashMap<String, VirtualWorld>();

    public void add(VirtualWorld virtualWorld) {
        if (virtualWorld.getName() == null) {
            throw new IllegalArgumentException("Unnamed world " + virtualWorld);
        }
        if (virtualWorld.getShard() == null) {
            throw new IllegalArgumentException("No user-agent speficied for world " + virtualWorld.getName());
        }
        this.nameToWorld.put(virtualWorld.getName(), virtualWorld);
    }

    public VirtualWorld worldNamed(String string) {
        return this.nameToWorld.get(string);
    }

    public VirtualWorld findWorld(HttpServletRequest httpServletRequest) {
        String string = SLHttpHeader.XSL_SHARD.getHeader(httpServletRequest);
        if (string == null) {
            return null;
        }
        VirtualWorld virtualWorld = this.shardToWorldCache.get(string);
        if (virtualWorld == null) {
            virtualWorld = this.findMatchingWorld(string);
            if (virtualWorld == null) {
                Debug.noteln("Could not find world for", (Object)string);
            } else {
                this.shardToWorldCache.put(string, virtualWorld);
            }
        }
        return virtualWorld;
    }

    private VirtualWorld findMatchingWorld(String string) {
        for (VirtualWorld virtualWorld : this.nameToWorld.values()) {
            if (!string.matches(virtualWorld.getShard())) continue;
            return virtualWorld;
        }
        return null;
    }
}

