/*
 * Decompiled with CFR 0.152.
 */
package ix.isim;

import ix.icore.Activity;
import ix.icore.IXAgent;
import ix.iface.util.ToolController;
import ix.isim.ISim;
import ix.isim.ISimTimeFrame;
import ix.isim.ISimTimerClient;
import ix.isim.ISimTimerException;
import ix.isim.ISimTimerServer;
import ix.util.Debug;
import ix.util.lisp.Symbol;

public abstract class ISimTimer {
    protected final Symbol SYNCHRONIZE_LABEL = Symbol.intern("synchronize-simulation-time");
    protected final String START = "start";
    protected final String PAUSE = "pause";
    protected final String RESUME = "resume";
    protected final String ACCELERATE = "accelerate";
    protected final String STOP = "stop";
    protected final String REGISTER = "register";
    protected IXAgent owner;
    protected boolean simulationActive = false;
    protected ISimTimeFrame simTimeDisplay;
    protected UpdateTimeDisplayThread tUpdater;
    private double accelerationFactor = 1.0;
    private long lastSimTimeChangeInReality = 0L;
    private long lastSimTimeChangeInSimTime = 0L;

    protected ISimTimer(IXAgent iXAgent) {
        this.owner = iXAgent;
        this.simTimeDisplay = new ISimTimeFrame();
        this.tUpdater = new UpdateTimeDisplayThread();
        ToolController toolController = new ToolController("I-Sim Clock"){

            public Object createTool() {
                return ISimTimer.this.simTimeDisplay;
            }
        };
        this.owner.addTool(toolController);
    }

    public abstract void handleSynchronizeActivity(Activity var1);

    public boolean simulationStarted() {
        return this.lastSimTimeChangeInReality > 0L;
    }

    public long getSimTimeInMillis() {
        if (this.simulationActive) {
            long l = System.currentTimeMillis() - this.lastSimTimeChangeInReality;
            long l2 = (long)((double)l * this.accelerationFactor);
            return this.lastSimTimeChangeInSimTime + l2;
        }
        return this.lastSimTimeChangeInSimTime;
    }

    public double getAccelerationFactor() {
        return this.accelerationFactor;
    }

    public void start(long l, double d) throws ISimTimerException {
        if (this.simulationStarted()) {
            throw new ISimTimerException("ISimTimer already started. Cannot start again.");
        }
        this.simulationActive = true;
        this.accelerationFactor = d;
        this.lastSimTimeChangeInReality = System.currentTimeMillis();
        this.lastSimTimeChangeInSimTime = l;
        this.tUpdater.start();
        this.simTimeDisplay.setRunning();
        if (this.owner instanceof ISim) {
            this.simTimeDisplay.setVisible(true);
        }
    }

    public long pause() {
        this.lastSimTimeChangeInSimTime = this.getSimTimeInMillis();
        this.lastSimTimeChangeInReality = System.currentTimeMillis();
        this.simulationActive = false;
        this.simTimeDisplay.setPaused();
        this.tUpdater.updateNow();
        return this.lastSimTimeChangeInSimTime;
    }

    public long resume() {
        this.simulationActive = true;
        this.lastSimTimeChangeInReality = System.currentTimeMillis();
        this.simTimeDisplay.setRunning();
        this.tUpdater.updateNow();
        return this.lastSimTimeChangeInSimTime;
    }

    public long changeAccelerationFactor(double d) {
        this.accelerationFactor = d;
        this.lastSimTimeChangeInReality = System.currentTimeMillis();
        this.lastSimTimeChangeInSimTime = this.getSimTimeInMillis();
        this.tUpdater.updateNow();
        return this.lastSimTimeChangeInSimTime;
    }

    public void terminateTimer() {
        this.tUpdater.terminate();
    }

    protected void setCurrentSimTime(long l) {
        this.lastSimTimeChangeInReality = System.currentTimeMillis();
        this.lastSimTimeChangeInSimTime = l;
    }

    public static ISimTimer getISimTimer(IXAgent iXAgent) {
        Debug.noteln("Creating ISimTimer ...");
        if (iXAgent instanceof ISim) {
            return new ISimTimerServer(iXAgent);
        }
        return new ISimTimerClient(iXAgent);
    }

    class UpdateTimeDisplayThread
    extends Thread {
        private boolean terminate = false;

        UpdateTimeDisplayThread() {
        }

        public synchronized void updateNow() {
            this.interrupt();
        }

        public synchronized void terminate() {
            this.terminate = true;
            ISimTimer.this.simTimeDisplay.setPaused();
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                UpdateTimeDisplayThread updateTimeDisplayThread = this;
                synchronized (updateTimeDisplayThread) {
                    ISimTimer.this.simTimeDisplay.setTime(ISimTimer.this.getSimTimeInMillis());
                }
                try {
                    UpdateTimeDisplayThread.sleep((long)(6000.0 / ISimTimer.this.accelerationFactor));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.terminate);
        }
    }
}

