/*
 * Decompiled with CFR 0.152.
 */
package ix.isim.dynamic;

import ix.isim.dynamic.MoveSpec;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.ParseException;

public class BearingMoveSpec
implements MoveSpec {
    static final double eRad = 6371000.0;
    double iLat = 0.0;
    double iLong = 0.0;
    double iBear = 0.0;
    double speedInMps = 0.0;
    long startTime = System.currentTimeMillis();

    public double getSpeed() {
        return this.speedInMps;
    }

    public String toString() {
        return "from latitude " + this.iLat + " longitude " + this.iLong + " bearing " + this.iBear + " speed " + this.speedInMps + " mps forever";
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    public double getCurrentLatitude() {
        double d = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double d2 = this.speedInMps * d / 6371000.0;
        return Math.asin(Math.sin(this.iLat) * Math.cos(d2) + Math.cos(this.iLat) * Math.sin(d2) * Math.cos(this.iBear)) / Math.PI * 180.0;
    }

    public double getCurrentLongitude() {
        double d = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double d2 = this.speedInMps * d / 6371000.0;
        return (this.iLong + Math.atan2(Math.sin(this.iBear) * Math.sin(d2) * Math.cos(this.iLat), Math.cos(d2) - Math.sin(this.iLat) * Math.sin(this.iLat))) / Math.PI * 180.0;
    }

    public boolean finished() {
        return false;
    }

    private double readNumeric(StreamTokenizer streamTokenizer, String string) throws ParseException, IOException {
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals(string)) {
            throw new ParseException("\"" + string + "\" expected", streamTokenizer.lineno());
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            throw new ParseException("numeric value expected", streamTokenizer.lineno());
        }
        double d = streamTokenizer.nval;
        streamTokenizer.nextToken();
        return d;
    }

    public BearingMoveSpec(StreamTokenizer streamTokenizer) throws ParseException, IOException {
        this.iLat = this.readNumeric(streamTokenizer, "latitude") / 180.0 * Math.PI;
        this.iLong = this.readNumeric(streamTokenizer, "longitude") / 180.0 * Math.PI;
        this.iBear = this.readNumeric(streamTokenizer, "bearing") / 180.0 * Math.PI;
        double d = this.readNumeric(streamTokenizer, "speed");
        if (streamTokenizer.ttype != -3) {
            throw new ParseException("unit for speed expected", streamTokenizer.lineno());
        }
        if (streamTokenizer.sval.equals("mps")) {
            this.speedInMps = d;
        } else if (streamTokenizer.sval.equals("kmph")) {
            this.speedInMps = d / 3.6;
        } else {
            throw new ParseException("unknown unit for spped", streamTokenizer.lineno());
        }
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals("forever")) {
            throw new ParseException("\"forever\" expected", streamTokenizer.lineno());
        }
        streamTokenizer.nextToken();
    }
}

