/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.ispace.AgentRelationship;
import ix.ispace.Capability;
import ix.ispace.LinkedListOfCapability;
import ix.ispace.ListOfCapability;
import ix.util.Debug;
import java.util.Collection;

public class AgentData {
    protected String name;
    protected AgentRelationship relationship;
    protected ListOfCapability capabilities = new LinkedListOfCapability();

    public AgentData() {
    }

    public AgentData(String string, AgentRelationship agentRelationship) {
        this.name = string;
        this.relationship = agentRelationship;
    }

    public AgentData(AgentData agentData) {
        this.name = agentData.name;
        this.relationship = agentData.relationship;
        this.capabilities = new LinkedListOfCapability((Collection)agentData.capabilities);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public AgentRelationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(AgentRelationship agentRelationship) {
        this.relationship = agentRelationship;
    }

    public ListOfCapability getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ListOfCapability listOfCapability) {
        this.capabilities = listOfCapability;
    }

    public void setCapabilities(Collection collection) {
        this.setCapabilities(new LinkedListOfCapability(collection));
    }

    public void addCapability(Capability capability) {
        Debug.noteln("Agent " + this.name + " gets " + capability);
        this.capabilities.add(capability);
    }

    public boolean hasCapability(Capability capability) {
        for (Capability capability2 : this.capabilities) {
            if (!capability2.subsumes(capability)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability capability, boolean bl) {
        return this.capabilitiesAreUnknown() ? bl : this.hasCapability(capability);
    }

    public boolean capabilitiesAreUnknown() {
        return this.capabilities.isEmpty();
    }

    public String toString() {
        return "AgentData[" + this.name + ", " + this.relationship + ", " + this.capabilities + "]";
    }
}

