/*
 * Decompiled with CFR 0.152.
 */
package ix.ispace;

import ix.icore.IXAgent;
import ix.icore.Sendable;
import ix.iface.util.CatchingActionListener;
import ix.ispace.AgentData;
import ix.ispace.AgentGroup;
import ix.ispace.ContactManager;
import ix.util.CatchingThread;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Fn;
import ix.util.IPC;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class GroupSender
implements ActionListener {
    protected IXAgent agent;
    protected Sendable contents;
    protected ContactManager contactManager;
    protected List groupNames;
    protected JFrame frame;
    protected Container contentPane;
    protected GroupPanel groupPanel;
    protected ButtonPanel buttonPanel;

    public GroupSender(IXAgent iXAgent, Sendable sendable) {
        this.agent = iXAgent;
        this.contents = sendable;
        this.contactManager = iXAgent.getContactManager();
        this.groupNames = (List)Collect.map(this.contactManager.getAgentGroups(), Fn.accessor(AgentGroup.class, "getName"));
        this.setUpFrame();
    }

    void setUpFrame() {
        this.frame = new JFrame(this.agent.getAgentDisplayName() + " Group Sender");
        this.contentPane = this.frame.getContentPane();
        this.groupPanel = new GroupPanel();
        this.buttonPanel = new ButtonPanel();
        this.contentPane.add((Component)this.groupPanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.frame.setSize(300, 200);
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("GroupSender action:", (Object)string);
        if (string.equals("Send")) {
            this.sendToSelectedGroup();
        } else if (string.equals("Cancel")) {
            this.frame.setVisible(false);
        } else {
            Debug.noteln("Nothing to do for", (Object)string);
        }
    }

    protected void sendToSelectedGroup() {
        this.groupPanel.sendingInit();
        this.buttonPanel.sendingInit();
        new SendingThread().start();
    }

    class ButtonPanel
    extends JPanel {
        JButton sendButton = this.makeButton("Send");
        JButton cancelButton = this.makeButton("Cancel");

        ButtonPanel() {
            this.add(this.sendButton);
            this.add(this.cancelButton);
        }

        JButton makeButton(String string) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(CatchingActionListener.listener(GroupSender.this));
            return jButton;
        }

        void sendingInit() {
            this.sendButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
        }
    }

    class GroupPanel
    extends JPanel
    implements ActionListener {
        JComboBox groupChoice;
        JList memberList;

        GroupPanel() {
            this.groupChoice = new JComboBox<Object>(GroupSender.this.groupNames.toArray());
            this.memberList = new JList();
            this.setLayout(new BoxLayout(this, 1));
            this.groupChoice.setBorder(BorderFactory.createTitledBorder("Group"));
            this.add(this.groupChoice);
            JScrollPane jScrollPane = new JScrollPane(this.memberList);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Members"));
            this.add(jScrollPane);
            this.groupChoice.addActionListener(CatchingActionListener.listener(this));
            this.groupChoice.setSelectedItem(GroupSender.this.groupNames.get(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.groupChoice) {
                this.memberList.setListData(this.getSelectedNames().toArray());
            }
        }

        Collection getSelectedNames() {
            String string = (String)this.groupChoice.getSelectedItem();
            Debug.noteln("Selected group", (Object)string);
            return this.getMemberNames(string);
        }

        Collection getMemberNames(String string) {
            AgentGroup agentGroup = GroupSender.this.contactManager.getAgentGroup(string);
            Collection collection = agentGroup.getKnownMembers();
            Debug.noteln("Group members", (Object)collection);
            return Collect.map(collection, Fn.accessor(AgentData.class, "getName"));
        }

        void sendingInit() {
            this.groupChoice.setEnabled(false);
        }

        void sendingTo(String string) {
            this.memberList.setSelectedValue(string, true);
        }
    }

    class SendingThread
    extends CatchingThread {
        Sendable messageContents;
        Collection toNames;
        int delay = 3000;

        SendingThread() {
            this.toNames = GroupSender.this.groupPanel.getSelectedNames();
            this.messageContents = GroupSender.this.contents;
        }

        public void innerRun() {
            for (final String string : this.toNames) {
                Debug.noteln("Sending to", (Object)string);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            GroupSender.this.groupPanel.sendingTo(string);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.sendTo(string, this.messageContents);
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GroupSender.this.frame.setVisible(false);
                }
            });
        }

        void sendTo(final String string, Sendable sendable) {
            CatchingThread catchingThread = new CatchingThread(){

                public void innerRun() {
                    IPC.sendObject(string, SendingThread.this.messageContents);
                }
            };
            catchingThread.start();
            try {
                catchingThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

