/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.GenericConstraint;
import ix.icore.IXObject;
import ix.icore.Issue;
import ix.icore.TaskItem;
import ix.icore.domain.Constraint;
import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.iface.ui.AbstractEditorPanel;
import ix.iface.ui.EditableObject;
import ix.iface.ui.IXLabelRenderer;
import ix.iface.ui.ListEditorPanel;
import ix.iface.ui.ThingEditorPanel;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTable;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.ConstructEditing;
import ix.iview.DomainEditorFrame;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIGrammar;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.util.Debug;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Symbol;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class GrammarEditorPanel
extends AConstructFramePanel
implements ActionListener,
UIDomainListener {
    private AbstractEditorPanel issuePatternList;
    private AbstractEditorPanel nodePatternList;
    private AbstractEditorPanel constraintPatternList;
    private HashSet issuePatterns = new HashSet();
    private HashSet nodePatterns = new HashSet();
    private List constrPatterns = new ArrayList();
    private MouseListener ml = new MouseAdapter(){};
    private boolean listsAsText = true;

    public GrammarEditorPanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
    }

    protected JPanel setupMainPanel() {
        this.mainPanel = new GrammarFormPanel(this);
        this.scrollPane.getViewport().add(this.mainPanel);
        this.listsAsText = this.parent.listsAsText();
        this.makeLists();
        return this.mainPanel;
    }

    public void refresh() {
        this.updatePatterns();
    }

    public boolean beforeSwitching() {
        return true;
    }

    public void setListsAsText(boolean bl) {
        if (this.listsAsText != bl) {
            this.listsAsText = bl;
            this.removeLists();
            this.makeLists();
            this.updatePatterns();
        }
    }

    private void makeLists() {
        this.issuePatternList = this.makeList(this.ml, "Issue Patterns");
        this.nodePatternList = this.makeList(this.ml, "Node Patterns");
        this.constraintPatternList = this.makeList(this.ml, "Constraint Patterns");
    }

    private void removeLists() {
        this.mainPanel.remove(this.issuePatternList);
        this.mainPanel.remove(this.nodePatternList);
        this.mainPanel.remove(this.constraintPatternList);
        this.issuePatternList.removeData();
        this.nodePatternList.removeData();
        this.constraintPatternList.removeData();
        this.issuePatternList = null;
        this.nodePatternList = null;
        this.constraintPatternList = null;
    }

    private AbstractEditorPanel makeList(MouseListener mouseListener, String string) {
        AbstractEditorPanel abstractEditorPanel;
        String[] stringArray = new String[]{"Add", "Delete", "Clear"};
        if (string.equals("Constraint Patterns")) {
            GenericConstraintTableModel genericConstraintTableModel = new GenericConstraintTableModel(this.parent.getUIDomain());
            IXTable iXTable = new IXTable(genericConstraintTableModel);
            iXTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
            abstractEditorPanel = new ListEditorPanel((EventListener)this, string, true, (JComponent)iXTable, stringArray);
        } else if (this.listsAsText) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setRows(5);
            abstractEditorPanel = new ThingEditorPanel((EventListener)mouseListener, string, jTextArea, stringArray);
        } else {
            JList jList = new JList();
            jList.setVisibleRowCount(5);
            jList.setCellRenderer(new IXLabelRenderer(false){

                public void setInfo(Object object) {
                    String string = "";
                    string = object instanceof Collection ? UIUtil.listToDisplay((Collection)object) : object.toString();
                    this.setText(string);
                }
            });
            abstractEditorPanel = new ListEditorPanel((EventListener)mouseListener, string, jList, stringArray);
        }
        ((AbstractEditorPanel)abstractEditorPanel).setEnabled(false);
        this.mainPanel.add(abstractEditorPanel);
        return abstractEditorPanel;
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return null;
    }

    public void newConstruct() {
    }

    public UIObject makeNewConstruct() {
        return null;
    }

    public void saveConstruct() {
        UIUtil.notImplemented(this, "Saving grammars");
    }

    protected UIObject noteConstruct() {
        return null;
    }

    public void setConstruct(IXObject iXObject) {
        if (iXObject == null) {
            this.issuePatternList.removeData();
            this.nodePatternList.removeData();
            this.constraintPatternList.removeData();
        } else {
            UIUtil.notImplemented(this, "Setting grammars");
        }
    }

    public boolean checkConstruct() {
        UIUtil.notImplemented(this, "Checking grammars");
        return true;
    }

    public List getAllConstructs() {
        return new LListCollector();
    }

    public Named getNamedConstruct(String string) {
        return null;
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructAdded(DomainEvent domainEvent) {
        this.updatePatterns();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.updatePatterns();
    }

    private void updatePatterns() {
        this.issuePatterns.clear();
        this.nodePatterns.clear();
        this.constrPatterns.clear();
        this.constrPatterns = this.getConstraintPatterns(null, this.constrPatterns);
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain != null) {
            List list = uIDomain.getAllRefinements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addAllPatterns(iterator.next());
            }
        }
        this.updateListPatterns(this.issuePatternList, this.issuePatterns);
        this.updateListPatterns(this.nodePatternList, this.nodePatterns);
        this.updateListPatterns(this.constraintPatternList, this.constrPatterns);
    }

    private void addAllPatterns(Object object) {
        if (object == null) {
            return;
        }
        Object var2_2 = null;
        List<NodeSpec> list = null;
        List<Issue> list2 = null;
        List<Constraint> list3 = null;
        Object var6_6 = null;
        if (Refinement.class.isInstance(object)) {
            Refinement refinement = (Refinement)object;
            this.nodePatterns.add(refinement.getPattern());
            list = refinement.getNodes();
            list2 = refinement.getIssues();
            list3 = refinement.getConstraints();
        } else if (UIRefinement.class.isInstance(object)) {
            UIRefinement uIRefinement = (UIRefinement)object;
            this.nodePatterns.add(uIRefinement.getPattern());
            list = uIRefinement.getNodes();
            list2 = uIRefinement.getIssues();
            list3 = uIRefinement.getConstraints();
        } else {
            Debug.noteln("GEP: Cannot get patterns from class ", (Object)object.getClass().getName());
            return;
        }
        this.nodePatterns = this.getNodePatterns(list, this.nodePatterns);
        if (list2 != null) {
            this.issuePatterns = this.getIssuePatterns(list2.iterator(), this.issuePatterns);
        }
        this.constrPatterns = this.getConstraintPatterns(list3, this.constrPatterns);
    }

    private void updateListPatterns(AbstractEditorPanel abstractEditorPanel, Collection collection) {
        LinkedList linkedList = new LinkedList(collection);
        abstractEditorPanel.setData(linkedList);
    }

    private void updateListPatterns(AbstractEditorPanel abstractEditorPanel, List list) {
        abstractEditorPanel.setData(list);
    }

    public HashSet getNodePatterns(Collection collection, HashSet hashSet) {
        Iterator iterator;
        if (collection != null && (iterator = collection.iterator()) != null) {
            while (iterator.hasNext()) {
                hashSet.add(((NodeSpec)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public HashSet getIssuePatterns(Iterator iterator, HashSet hashSet) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                hashSet.add(((TaskItem)iterator.next()).getPattern());
            }
        }
        return hashSet;
    }

    public List getConstraintPatterns(Collection collection, List list) {
        UIGrammar uIGrammar = this.parent.getUIDomain().getGrammar();
        uIGrammar.addGenericConstraints(collection);
        return uIGrammar.getConstraintPatterns();
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string != "editConstruct") {
            if (string == "modify") {
                this.saveConstruct();
            } else if (string == "check") {
                this.checkConstruct();
            } else {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("Grammar editor: Got action command", (Object)string);
    }

    protected class GenericConstraintTableModel
    extends AbstractIXTableModel {
        protected UIDomain uiDomain;

        public GenericConstraintTableModel(UIDomain uIDomain) {
            super(false);
            this.setupColumns();
            this.setDomain(uIDomain);
        }

        private void setupColumns() {
            Class[] classArray = new Class[]{Symbol.class, Symbol.class, String.class, Object.class};
            String[] stringArray = new String[]{"Type", "Relation", "Parameters", "Example"};
            super.setColumnClasses(classArray);
            super.setColumnNames(stringArray);
        }

        public void setDomain(UIDomain uIDomain) {
            this.uiDomain = uIDomain;
            this.reloadData();
        }

        public void reloadData() {
            UIGrammar uIGrammar = this.uiDomain.getGrammar();
            LinkedList linkedList = new LinkedList(uIGrammar.getAllConstraintPatterns(this.uiDomain));
            if (linkedList == null) {
                this.clearData();
            } else {
                this.setData(linkedList.toArray());
            }
        }

        public Object getCellValueAt(Object object, int n) {
            if (object == null) {
                return "";
            }
            try {
                GenericConstraint genericConstraint = (GenericConstraint)object;
                if (n == 0) {
                    return genericConstraint.getType();
                }
                if (n == 1) {
                    return genericConstraint.getRelation();
                }
                if (n == 2) {
                    return genericConstraint.getForm();
                }
                if (n == 3) {
                    return genericConstraint.getExample();
                }
                return "";
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                return "";
            }
        }
    }

    public class GrammarFormPanel
    extends JPanel
    implements ConstructEditing {
        private AConstructFramePanel parent;
        private UIObject uiConstruct;

        public GrammarFormPanel(AConstructFramePanel aConstructFramePanel) {
            super(new GridLayout(3, 1));
            this.parent = aConstructFramePanel;
        }

        public UIDomain getUIDomain() {
            return this.parent.getUIDomain();
        }

        public void setConstruct(IXObject iXObject) {
            this.setUIConstruct(this.getUIDomain().getUIObject(iXObject));
        }

        public IXObject getConstruct() {
            if (this.uiConstruct == null) {
                return null;
            }
            return this.uiConstruct.getBaseObject();
        }

        public void setUIConstruct(UIObject uIObject) {
            this.setUIConstructOnly(uIObject);
        }

        public void setUIConstructOnly(UIObject uIObject) {
            UIObject uIObject2 = this.uiConstruct;
            this.uiConstruct = uIObject;
            this.parent.fireConstructChanged(uIObject2, uIObject, this);
        }

        public UIObject getUIConstruct() {
            return this.uiConstruct;
        }

        public void loadFromObject() {
        }

        public void saveToObject(EditableObject editableObject) {
        }
    }
}

