/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.iface.ui.JPreferencesDialog;
import ix.iface.ui.JPropertiesManager;
import ix.iview.DomainEditorFrame;
import ix.iview.IDESymbols;
import ix.iview.util.IDEUtil;
import ix.util.Debug;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IDEPreferencesDialog
extends JPreferencesDialog
implements IDESymbols,
ChangeListener {
    public IDEPreferencesDialog(DomainEditorFrame domainEditorFrame, JPropertiesManager jPropertiesManager) {
        super(domainEditorFrame, jPropertiesManager);
    }

    public void makeComponents() {
        Box box = new Box(1);
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        JCheckBox jCheckBox = new JCheckBox("Simple mode");
        jCheckBox.setActionCommand(MODE_SIMPLE.toString());
        jCheckBox.setToolTipText("Set the mode to simple (tick) or advanced (no tick)");
        jCheckBox.setSelected(this.manager.getProperty("ideMode").equals(jCheckBox.getActionCommand()));
        jCheckBox.addChangeListener(this);
        box.add(jCheckBox);
        arrayList.add(jCheckBox);
        this.keyComponents.put("ideMode", arrayList);
        arrayList = new ArrayList();
        JCheckBox jCheckBox2 = new JCheckBox("Set editable");
        jCheckBox2.setActionCommand("propEditable");
        jCheckBox2.setToolTipText("Switch off to use the editor as a viewer only");
        jCheckBox2.setSelected(this.manager.getProperty("ideEditable").equals("true"));
        jCheckBox2.setEnabled(false);
        box.add(jCheckBox2);
        this.keyComponents.put("ideEditable", arrayList);
        arrayList = new ArrayList();
        jCheckBox2 = new JCheckBox("Show text on toolbar buttons");
        jCheckBox2.setActionCommand("showButtText");
        jCheckBox2.setToolTipText("Toggle text on toolbar buttons on/off");
        jCheckBox2.setSelected(this.manager.getProperty("ideShowButtonTexts").equals("true"));
        box.add(jCheckBox2);
        arrayList.add(jCheckBox2);
        this.keyComponents.put("ideShowButtonTexts", arrayList);
        arrayList = new ArrayList();
        jCheckBox2 = new JCheckBox("Use object constraint editor");
        jCheckBox2.setActionCommand("useNewCondEd");
        jCheckBox2.setToolTipText("Use object-style condition/effect editor");
        jCheckBox2.setSelected(this.manager.getProperty("ideNewCondEditor").equals("true"));
        box.add(jCheckBox2);
        arrayList.add(jCheckBox2);
        this.keyComponents.put("ideNewCondEditor", arrayList);
        arrayList = new ArrayList();
        jCheckBox2 = new JCheckBox("Use text fields for lists");
        jCheckBox2.setActionCommand("ListsAsTexts");
        jCheckBox2.setToolTipText("Edit by typing (tick) or dialogue (no tick)");
        jCheckBox2.setSelected(this.manager.getProperty("ideListsAsTexts").equals("true"));
        jCheckBox2.setEnabled(true);
        box.add(jCheckBox2);
        arrayList.add(jCheckBox2);
        this.keyComponents.put("ideListsAsTexts", arrayList);
        this.prefsPanel.add(box);
        this.makeRadioComponent("idePanelStyle", "Preferred Panel Style", ((DomainEditorFrame)this.frame).getPanelStyles(), "is the preferred style");
        this.makeRadioComponent("ideActivityView", "Preferred Activity View", Arrays.asList(VIEWS), "is the preferred activity view");
        String[] stringArray = new String[]{"orderings", "conditions/effects", "other constraints"};
        this.makeCheckBoxComponent("ideConstraints", "Preferred Constraints View", Arrays.asList(stringArray), "should be shown");
        this.simpleEffect(jCheckBox);
    }

    public boolean setComponentFromProperty(String string, List list, String string2) {
        boolean bl = false;
        if (list == null) {
            Debug.noteln("no components for", (Object)string);
            return bl;
        }
        if (string.equals("ideConstraints")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string3 = jToggleButton.getActionCommand();
                    if (IDEUtil.showConstraints(string3, Symbol.intern(string2))) {
                        jToggleButton.setSelected(true);
                    } else {
                        jToggleButton.setSelected(false);
                    }
                    bl = true;
                }
                catch (Exception exception) {}
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string4 = jToggleButton.getActionCommand();
                    if (string4.equals(string2)) {
                        jToggleButton.setSelected(true);
                    } else {
                        jToggleButton.setSelected(false);
                    }
                    bl = true;
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return bl;
    }

    protected void setEnabledComponent(Component component, boolean bl) {
        try {
            ((JToggleButton)component).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPropertyFromComponent(String string, List list) {
        if (string.equals("ideMode")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string2 = jToggleButton.getActionCommand();
                    if (jToggleButton.isSelected()) {
                        return MODE_SIMPLE.toString();
                    }
                    return MODE_ADVANCED.toString();
                }
                catch (Exception exception) {
                }
            }
            return this.manager.getProperty(string);
        }
        if (string.equals("idePanelStyle")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string3 = jToggleButton.getActionCommand();
                    if (!jToggleButton.isSelected()) continue;
                    return jToggleButton.getActionCommand();
                }
                catch (Exception exception) {
                }
            }
            return this.manager.getProperty(string);
        }
        if (string.equals("ideActivityView")) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    JToggleButton jToggleButton = (JToggleButton)iterator.next();
                    String string4 = jToggleButton.getActionCommand();
                    if (!jToggleButton.isSelected()) continue;
                    return jToggleButton.getActionCommand();
                }
                catch (Exception exception) {
                }
            }
            return this.manager.getProperty(string);
        }
        if (string.equals("ideConstraints")) {
            boolean[] blArray = new boolean[]{true, true, true};
            int n = 0;
            try {
                for (JToggleButton jToggleButton : list) {
                    String string5 = jToggleButton.getActionCommand();
                    blArray[n] = jToggleButton.isSelected();
                    ++n;
                }
                return IDEUtil.makeConstPrefSymbol(blArray[0], blArray[1], blArray[2]).toString();
            }
            catch (Exception exception) {
                return this.manager.getProperty(string);
            }
        }
        return this.manager.getProperty(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.simpleEffect((JToggleButton)changeEvent.getSource());
    }

    private void simpleEffect(JToggleButton jToggleButton) {
        if (jToggleButton.isSelected()) {
            List list = (List)this.keyComponents.get("idePanelStyle");
            this.setEnabledComponents("idePanelStyle", list, false);
            list = (List)this.keyComponents.get("ideActivityView");
            this.setEnabledComponents("ideActivityView", list, false);
            this.setEnabledComponents("ideConstraints", false);
        } else {
            this.setEnabledComponents("idePanelStyle", true);
            this.setEnabledComponents("ideActivityView", true);
            this.setEnabledComponents("ideConstraints", true);
        }
    }

    public void localCommandClicked(String string) {
    }
}

