/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.ObjectClass;
import ix.icore.domain.ObjectProperty;
import ix.icore.domain.Refinement;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIObjectClass;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Symbol;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.tree.TreeNode;

public class ObjectClassGenerator {
    private UIDomain uiDomain;
    private UIObjectClass root;
    private int num;

    public void generateObjectClasses(UIDomain uIDomain) {
        this.fillObjectClasses(uIDomain);
    }

    public void fillObjectClasses(UIDomain uIDomain) {
        this.uiDomain = uIDomain;
        this.root = uIDomain.getObjectClassRoot();
        if (this.root == null) {
            this.root = new UIObjectClass(uIDomain, "Root");
            uIDomain.addConstruct(this.root);
        }
        this.num = 1;
        List list = uIDomain.getAllRefinements();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            if (e == null) continue;
            if (e instanceof Refinement) {
                this.fillTypesFromConstraints((Refinement)e);
                continue;
            }
            if (e instanceof UIRefinement) {
                this.fillTypesFromConstraints((UIRefinement)e);
                continue;
            }
            Debug.noteln("OCGen: looking for refinement class, found", e);
        }
        if (this.root == null) {
            uIDomain.getObjectClassRoot();
        }
        for (Object e : list) {
            if (e == null) continue;
            if (e instanceof Refinement) {
                this.fillPropertiesFromConstraints((Refinement)e);
                continue;
            }
            if (e instanceof UIRefinement) {
                this.fillPropertiesFromConstraints((UIRefinement)e);
                continue;
            }
            Debug.noteln("OCGen: looking for refinement class, found", e);
        }
        uIDomain.fireDomainEdited();
    }

    private void fillTypesFromConstraints(Refinement refinement) {
        SortedSet sortedSet = refinement.getVariablesUsed();
        ListOfConstraint listOfConstraint = refinement.getConstraints();
        List list = UIRefinement.filterForConditions(listOfConstraint);
        this.fillTypesFromConstraints(sortedSet, list);
    }

    private void fillTypesFromConstraints(UIRefinement uIRefinement) {
        SortedSet sortedSet = uIRefinement.getVariablesUsed();
        List list = uIRefinement.getConditions();
        this.fillTypesFromConstraints(sortedSet, list);
    }

    private void fillTypesFromConstraints(Set set, List list) {
        if (set == null || list == null) {
            return;
        }
        for (Object e : set) {
            if (!(e instanceof ItemVar)) continue;
            Object object = IVUtil.findVariableClass((ItemVar)e, list);
            this.foundType(object);
        }
    }

    private UIObjectClass foundType(Object object) {
        if (object == null || object.toString() == null || object.toString() == "") {
            return null;
        }
        Object object2 = this.uiDomain.getNamedObjectClass(object.toString());
        if (object2 != null) {
            return this.ensureUIOC(object2);
        }
        Debug.noteln("OCGen: foundType new oc", object);
        return this.foundObjectClass(new UIObjectClass(this.uiDomain, object.toString()));
    }

    private UIObjectClass foundObjectClass(UIObjectClass uIObjectClass) {
        if (uIObjectClass == null) {
            return null;
        }
        Object object = this.uiDomain.getNamedObjectClass(uIObjectClass.getName());
        if (object == null) {
            TreeNode treeNode = uIObjectClass.getParent();
            if (treeNode == null && this.root != null) {
                uIObjectClass.addParent(this.root);
            }
            this.uiDomain.addConstruct(uIObjectClass);
            return uIObjectClass;
        }
        return this.ensureUIOC(object);
    }

    private UIObjectClass ensureUIOC(Object object) {
        if (object instanceof UIObjectClass) {
            return (UIObjectClass)object;
        }
        if (object instanceof ObjectClass) {
            Debug.noteln("OCGen: ensuring new oc", object);
            UIObjectClass uIObjectClass = new UIObjectClass(this.uiDomain, (ObjectClass)object);
            this.uiDomain.addConstruct(uIObjectClass);
            return uIObjectClass;
        }
        return null;
    }

    private void fillPropertiesFromConstraints(Refinement refinement) {
        SortedSet sortedSet = refinement.getVariablesUsed();
        ListOfConstraint listOfConstraint = refinement.getConstraints();
        List list = UIRefinement.filterForConditions(listOfConstraint);
        this.fillPropertiesFromConstraints(sortedSet, list);
    }

    private void fillPropertiesFromConstraints(UIRefinement uIRefinement) {
        SortedSet sortedSet = uIRefinement.getVariablesUsed();
        List list = uIRefinement.getConditions();
        this.fillPropertiesFromConstraints(sortedSet, list);
    }

    private void fillPropertiesFromConstraints(Set set, List list) {
        if (set == null || list == null) {
            return;
        }
        for (Object e : set) {
            Object object;
            UIObjectClass uIObjectClass;
            Object object2;
            String string = "AnonClass" + e.toString() + this.num;
            if (!(e instanceof ItemVar)) continue;
            List list2 = UIRefinement.filterForVariable((ItemVar)e, list);
            Object object3 = IVUtil.findVariableClass((ItemVar)e, list2);
            if (object3 == null) {
                object3 = string;
                ++this.num;
            }
            if ((object2 = this.uiDomain.getNamedObjectClass(object3.toString())) == null) {
                object2 = this.foundType(object3);
            }
            if ((uIObjectClass = this.ensureUIOC(object2)) != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    String string2;
                    Constraint constraint;
                    Object e2 = object.next();
                    if (!(e2 instanceof Constraint) || IVUtil.isClassConstraint((ItemVar)e, constraint = (Constraint)e2) || (string2 = IVUtil.propertyFromConstraint(constraint)) == null || string2.equals("") || uIObjectClass.isProperty(string2)) continue;
                    ObjectProperty.Syntax syntax = this.getPropertyType(constraint);
                    uIObjectClass.addProperty(Symbol.intern(string2), syntax);
                }
            }
            if (uIObjectClass == null || !string.equals(uIObjectClass.getName()) || (object = uIObjectClass.getAllProperties()) != null && !object.isEmpty()) continue;
            try {
                this.uiDomain.removeConstruct(uIObjectClass);
            }
            catch (Exception exception) {}
        }
    }

    private ObjectProperty.Syntax getPropertyType(Constraint constraint) {
        Object object = IVUtil.getConstraintValue(constraint);
        if (object != null) {
            if (object instanceof ItemVar) {
                return ObjectProperty.Syntax.DEFAULT;
            }
            if (object instanceof Symbol) {
                return ObjectProperty.Syntax.SYMBOL;
            }
            Debug.noteln("OCGen: got value " + object.toString() + " of class", object.getClass());
        }
        return ObjectProperty.Syntax.DEFAULT;
    }
}

