/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.table;

import ix.icore.IXObject;
import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.Refinement;
import ix.icore.domain.event.DomainEvent;
import ix.icore.domain.event.RefinementEvent;
import ix.iface.ui.FourField;
import ix.iface.ui.table.AbstractTreeTableModel;
import ix.iface.ui.table.IXTNTreeTableNode;
import ix.iface.ui.table.IXTreeTableNode;
import ix.iface.ui.util.UIUtil;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UIRefinement;
import ix.iview.domain.event.UIDomainEvent;
import ix.iview.domain.event.UIDomainListener;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.LList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ActionTreeTableModel
extends AbstractTreeTableModel
implements UIDomainListener {
    protected UIDomain uiDomain;
    protected int PATTERN_COL = 1;
    private boolean sort = false;

    public ActionTreeTableModel(boolean bl, UIDomain uIDomain) {
        super(bl);
        this.setColumnNames();
        this.setDomain(uIDomain);
    }

    public void setDomain(UIDomain uIDomain) {
        this.uiDomain = uIDomain;
        this.uiDomain.addUIDomainListener(this);
        List list = this.uiDomain.getAllRefinements();
        if (this.sort) {
            list = (List)IVUtil.sortNamedCollection(new ArrayList(list));
        }
        this.updateData(list);
    }

    public IXTreeTableNode makeIXTreeTableNode(Object object) {
        IXTNTreeTableNode iXTNTreeTableNode = null;
        TreeNode treeNode = object == null ? null : (object instanceof TreeNode ? (TreeNode)object : (object instanceof IXObject ? (TreeNode)((Object)this.uiDomain.getUIObject((IXObject)object)) : null));
        iXTNTreeTableNode = treeNode == null ? null : new IXTNTreeTableNode((AbstractTreeTableModel)this, treeNode);
        return iXTNTreeTableNode;
    }

    public Object getCellValueAt(Object object, int n) {
        IXTNTreeTableNode iXTNTreeTableNode = (IXTNTreeTableNode)object;
        if (n == this.PATTERN_COL) {
            LList lList = this.getPattern(iXTNTreeTableNode);
            return UIUtil.listToDisplay(lList);
        }
        return null;
    }

    public String getNameString(TreeNode treeNode) {
        IXTNTreeTableNode iXTNTreeTableNode = (IXTNTreeTableNode)treeNode;
        return ((Named)((Object)iXTNTreeTableNode.node)).getName();
    }

    void setColumnNames() {
        Class[] classArray = new Class[]{FourField.class, String.class};
        String[] stringArray = new String[]{"Name", "Pattern"};
        super.setColumnClasses(classArray);
        super.setColumnNames(stringArray);
    }

    protected LList getPattern(IXTNTreeTableNode iXTNTreeTableNode) {
        TreeNode treeNode = iXTNTreeTableNode.node;
        LList lList = null;
        if (treeNode instanceof UIRefinement) {
            lList = ((UIRefinement)treeNode).getPattern();
        } else if (treeNode instanceof Refinement) {
            lList = ((Refinement)((Object)treeNode)).getPattern();
        } else if (treeNode instanceof NodeSpec) {
            lList = ((NodeSpec)((Object)treeNode)).getPattern();
        } else {
            Debug.noteln("ActTTM: found node with odd class", treeNode.getClass());
        }
        return lList;
    }

    public void reloadData() {
        List list = this.uiDomain.getAllRefinements();
        if (this.sort) {
            list = (List)IVUtil.sortNamedCollection(new ArrayList(list));
        }
        LinkedList linkedList = new LinkedList(list);
        this.updateData(linkedList);
    }

    public void resetData() {
        this.reloadData();
    }

    public void setSort(boolean bl) {
        this.sort = bl;
        this.reloadData();
    }

    public boolean getSort() {
        return this.sort;
    }

    public boolean isOwnObject(Object object) {
        return object instanceof UIRefinement || object instanceof Refinement;
    }

    public void refinementAdded(RefinementEvent refinementEvent) {
        if (!this.uiDomain.isLoading()) {
            this.addData(refinementEvent.getRefinement());
        }
    }

    public void refinementRemoved(RefinementEvent refinementEvent) {
        this.removeData(refinementEvent.getRefinement());
    }

    public void constructAdded(UIDomainEvent uIDomainEvent) {
        if (!this.uiDomain.isLoading() && this.isOwnObject(uIDomainEvent.getObject())) {
            this.addData(uIDomainEvent.getObject());
        }
    }

    public void constructAdded(DomainEvent domainEvent) {
        if (!this.uiDomain.isLoading() && domainEvent instanceof RefinementEvent) {
            this.addData(((RefinementEvent)domainEvent).getRefinement());
        }
    }

    public void constructRemoved(UIDomainEvent uIDomainEvent) {
        this.reloadData();
    }

    public void constructEdited(UIDomainEvent uIDomainEvent) {
        this.fireObjectChanged(uIDomainEvent.getObject());
    }

    public void domainCleared(UIDomainEvent uIDomainEvent) {
        this.clearData();
        this.fireTableDataChanged();
    }

    public void domainEdited(UIDomainEvent uIDomainEvent) {
        this.setDomain(uIDomainEvent.getDomain());
    }

    public void domainSet(UIDomainEvent uIDomainEvent) {
        this.setDomain(uIDomainEvent.getDomain());
    }
}

