/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.util;

import ix.icore.Priority;
import ix.iface.ui.IXLabelRenderer;
import ix.iview.util.EditablePriority;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.Util;
import javax.swing.ImageIcon;

public class PriorityRenderer
extends IXLabelRenderer {
    private static final ImageIcon editableIcon = Util.resourceImageIcon("ix-symbol-editable.gif");
    private static final ImageIcon disabledIcon = Util.resourceImageIcon("ix-symbol-editable-disabled.gif");

    public PriorityRenderer(boolean bl) {
        super(bl);
    }

    public void setInfo(Object object) {
        if (object == null) {
            Debug.noteln("PriorityRenderer: cannot render null values!");
            return;
        }
        if (Priority.class.isInstance(object)) {
            Priority priority = (Priority)object;
            this.setBackground(priority.getColor());
            this.setText(Strings.capitalize(priority.toString()));
        } else if (EditablePriority.class.isInstance(object)) {
            EditablePriority editablePriority = (EditablePriority)object;
            Priority priority = editablePriority.priority;
            this.setBackground(priority.getColor());
            this.setText(Strings.capitalize(priority.toString()));
            ImageIcon imageIcon = editablePriority.editable ? editableIcon : disabledIcon;
            this.setIcon(imageIcon);
        } else {
            Debug.noteln("PriorityRenderer got object of class", (Object)object.getClass().getName());
            Debug.noteln("Using toString to set text");
            this.setText(object.toString());
        }
    }
}

