/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.domain.Constraint;
import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.NodeSpec;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.icore.plan.Plan;
import ix.icore.plan.build.SimplePlanBuilder;
import ix.icore.process.PNodeEnd;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.Slip;
import ix.iview.SimpleDomainEditor;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispObject;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockStacker {
    protected Slip slip;
    protected List<List<Symbol>> initialTowers;
    protected List<List<Symbol>> finalTowers;
    protected String problem;
    protected Domain baseDomain;
    protected static final Symbol S_ACHIEVE = Symbol.intern("achieve");
    protected static final Symbol S_ON = Symbol.intern("on");
    protected static final Symbol S_BLOCK = Symbol.intern("block");
    protected static final Symbol S_CLEARTOP = Symbol.intern("cleartop");
    protected static final Symbol S_TABLE = Symbol.intern("table");
    protected static final Symbol S_TRUE = Symbol.intern("true");
    protected static final Symbol S_FALSE = Symbol.intern("false");

    public BlockStacker(String string) {
        this.problem = string;
        this.parseTowers(string);
    }

    public List<List<Symbol>> getInitialTowers() {
        return this.initialTowers;
    }

    public List<List<Symbol>> getFinalTowers() {
        return this.finalTowers;
    }

    public void setBaseDomain(Domain domain) {
        this.baseDomain = domain;
    }

    protected abstract String getDefaultBaseDomainName();

    public void findPlan() {
        this.setupForPlanning();
        this.slip.plan();
    }

    public void replan() {
        this.slip.replan();
    }

    public Plan getPlan() {
        return this.slip.getPlan();
    }

    protected void setupForPlanning() {
        Object object;
        this.slip = new Slip(true);
        this.slip.mainStartup(new String[0]);
        if (this.baseDomain == null) {
            object = Parameters.getParameter("base-domain", this.getDefaultBaseDomainName());
            this.baseDomain = new Domain();
            this.slip.readDomain(this.baseDomain, (String)object);
        }
        object = this.problemDomain(this.initialTowers, this.finalTowers);
        ((Domain)object).takeFrom(this.baseDomain);
        XML.writeObject(object, "/tmp/dom.lsp");
        Plan plan = this.initialPlan(this.initialTowers, this.finalTowers);
        if (Parameters.haveParameter("step-limit")) {
            this.slip.setStepLimit(Parameters.getInt("step-limit"));
        }
        this.slip.setDomain((Domain)object);
        this.slip.loadPlan(plan);
    }

    public void checkPlan() {
        PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(this.slip);
        planCheckingSimulator.run();
        planCheckingSimulator.report();
        planCheckingSimulator.describeFinalWorldState();
        this.checkTowerState(planCheckingSimulator.getWorldStateMap(), this.finalTowers);
        planCheckingSimulator.traceln("Problem =", this.problem);
        planCheckingSimulator.traceln("Move steps in order:");
        for (PNodeEnd pNodeEnd : planCheckingSimulator.getExecutionOrder()) {
            LList lList;
            if (pNodeEnd.getEnd() != End.BEGIN || !(lList = pNodeEnd.getNode().getPattern()).get(0).toString().startsWith("move")) continue;
            planCheckingSimulator.traceln("   ", lList);
        }
    }

    public void parseTowers(String string) {
        String[] stringArray = Strings.breakAtFirst("-", string);
        this.initialTowers = this.towers(stringArray[0]);
        this.finalTowers = this.towers(stringArray[1]);
        this.checkSameBlocks(this.initialTowers, this.finalTowers);
        Debug.noteln("Initial towers", this.initialTowers);
        Debug.noteln("Final towers", this.finalTowers);
        Debug.noteln("First tower's patterns", (Object)this.towerPatterns(this.initialTowers.get(0)));
    }

    List<List<Symbol>> towers(String string) {
        List<String> list = Strings.breakAt(",", string);
        LinkedList<List<Symbol>> linkedList = new LinkedList<List<Symbol>>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.towerBlocks(iterator.next()));
        }
        return linkedList;
    }

    List<Symbol> towerBlocks(String string) {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2 = string.substring(i, i + 1);
            linkedList.add(Symbol.intern(string2));
        }
        return linkedList;
    }

    void checkSameBlocks(List<List<Symbol>> list, List<List<Symbol>> list2) {
        Set<Symbol> set = this.blockSet(list);
        Set<Symbol> set2 = this.blockSet(list2);
        Set set3 = (Set)Collect.difference(set, set2);
        Set set4 = (Set)Collect.difference(set2, set);
        if (!set3.isEmpty()) {
            throw new IllegalArgumentException("Extra blocks in initial towers:" + set3);
        }
        if (!set4.isEmpty()) {
            throw new IllegalArgumentException("Extra blocks in final towers:" + set4);
        }
    }

    Set<Symbol> blockSet(List<List<Symbol>> list) {
        TreeSet<Symbol> treeSet = new TreeSet<Symbol>();
        for (List<Symbol> list2 : list) {
            for (Symbol symbol : list2) {
                if (treeSet.add(symbol)) continue;
                throw new IllegalArgumentException("Block appears twice: " + symbol);
            }
        }
        return treeSet;
    }

    public Plan initialPlan() {
        return this.initialPlan(this.initialTowers, this.finalTowers);
    }

    public Plan initialPlan(List list, List list2) {
        SimplePlanBuilder simplePlanBuilder = new SimplePlanBuilder();
        simplePlanBuilder.addActivity(new Activity(this.pattern("(stacking-problem)")));
        return simplePlanBuilder.getPlan();
    }

    public Domain problemDomain() {
        return this.problemDomain(this.initialTowers, this.finalTowers);
    }

    public Domain problemDomain(List list, List list2) {
        Domain domain = new Domain();
        domain.addRefinement(this.problemTaskRefinement());
        domain.addRefinement(this.initialStateRefinement(list));
        domain.addRefinement(this.goalStateRefinement(list2));
        return domain;
    }

    Refinement problemTaskRefinement() {
        Refinement refinement = new Refinement("stacking-problem", this.pattern("(stacking-problem)"));
        refinement.setNodes(Lisp.list(new NodeSpec("1", this.pattern("(setup-problem)")), new NodeSpec("2", this.pattern("(problem-goal)"))));
        refinement.setOrderings(SimpleDomainEditor.sequentialOrderings(refinement.getNodes()));
        return refinement;
    }

    protected Refinement initialStateRefinement(List list) {
        LispObject lispObject;
        Refinement refinement = new Refinement("setup-problem", this.pattern("(setup-problem)"));
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        Set set = this.allBlocks(list);
        for (Object object : set) {
            lispObject = Lisp.list(S_BLOCK, object);
            linkedListOfConstraint.add(this.worldEffect((LList)lispObject));
        }
        for (Object object : list) {
            lispObject = (Symbol)object.get(0);
            Cons cons = Lisp.list(S_CLEARTOP, lispObject);
            linkedListOfConstraint.add(this.worldEffect(cons));
            for (LList lList : this.towerPatterns((List)object)) {
                linkedListOfConstraint.add(this.worldEffect(lList));
            }
        }
        refinement.setConstraints(linkedListOfConstraint);
        return refinement;
    }

    protected abstract Refinement goalStateRefinement(List var1);

    LList pattern(String string) {
        return (LList)Lisp.readFromString(string);
    }

    Set allBlocks(List list) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            treeSet.addAll((List)iterator.next());
        }
        return treeSet;
    }

    Constraint worldEffect(LList lList) {
        return new Constraint("world-state", "effect", (List)Lisp.list(new PatternAssignment(lList)));
    }

    List towerPatterns(List list) {
        LinkedList<Cons> linkedList = new LinkedList<Cons>();
        Iterator iterator = list.iterator();
        Symbol symbol = (Symbol)iterator.next();
        while (iterator.hasNext()) {
            Symbol symbol2 = (Symbol)iterator.next();
            linkedList.add(Lisp.list(S_ON, symbol, symbol2));
            symbol = symbol2;
        }
        linkedList.add(Lisp.list(S_ON, symbol, S_TABLE));
        return linkedList;
    }

    public void checkTowerState(Map map, List list) {
        List list2 = this.incorrectTowerPatterns(map, list);
        if (list2.isEmpty()) {
            Debug.noteln("World state is correct");
        } else {
            Debug.noteln("Incorrect patterns", (Object)list2);
        }
    }

    public List failedGoalPatterns(Map map) {
        return this.incorrectTowerPatterns(map, this.finalTowers);
    }

    public List incorrectTowerPatterns(Map map, List list) {
        LinkedList linkedList = new LinkedList();
        for (List list2 : list) {
            Symbol symbol = (Symbol)list2.get(0);
            Cons cons = Lisp.list(S_CLEARTOP, symbol);
            this.checkPattern(map, cons, S_TRUE, linkedList);
            for (LList lList : this.towerPatterns(list2)) {
                this.checkPattern(map, lList, S_TRUE, linkedList);
                Symbol symbol2 = (Symbol)lList.get(2);
                Cons cons2 = Lisp.list(S_CLEARTOP, symbol2);
                if (symbol2 == S_TABLE || map.get(cons2) == null) continue;
                this.checkPattern(map, cons2, S_FALSE, linkedList);
            }
        }
        return linkedList;
    }

    void checkPattern(Map map, LList lList, Symbol symbol, List list) {
        Object v = map.get(lList);
        if (v == null || v != symbol) {
            list.add(lList);
        }
    }
}

