/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.Predicate1;
import ix.util.RethrownException;
import ix.util.lisp.Lisp;
import ix.util.lisp.LispReader;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DigestSet {
    protected MessageDigest md = DigestSet.makeMessageDigest();
    protected Set digested = new HashSet();
    protected Map digestObjectCache = new WeakHashMap();

    public boolean add(Object object) {
        return this.digested.add(this.memoizedDigestObject(object));
    }

    public boolean contains(Object object) {
        return this.digested.contains(this.memoizedDigestObject(object));
    }

    public BigInteger digestObject(Object object) {
        this.md.reset();
        this.md.update(XML.objectToXMLString(object).getBytes());
        return new BigInteger(1, this.md.digest());
    }

    public BigInteger memoizedDigestObject(Object object) {
        BigInteger bigInteger = (BigInteger)this.digestObjectCache.get(object);
        if (bigInteger == null) {
            bigInteger = this.digestObject(object);
            this.digestObjectCache.put(object, bigInteger);
        }
        Debug.noteln("Digested " + object + " = " + bigInteger);
        return bigInteger;
    }

    private static MessageDigest makeMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RethrownException(noSuchAlgorithmException);
        }
    }

    public static void main(String[] stringArray) {
        DigestSet digestSet = new DigestSet();
        LispReader lispReader = new LispReader(System.in);
        Symbol symbol = Symbol.intern("bye");
        while (true) {
            System.out.print("Lisp: ");
            try {
                Object object = lispReader.readObject();
                if (object == symbol) {
                    return;
                }
                System.out.println(Lisp.printToString(object));
                System.out.println(digestSet.digestObject(object));
                System.out.println(digestSet.memoizedDigestObject(object));
                System.out.println("Seen before = " + !digestSet.add(object));
                continue;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                continue;
            }
            break;
        }
    }

    public class IsNewPredciate
    implements Predicate1 {
        public boolean trueOf(Object object) {
            return DigestSet.this.add(object);
        }
    }
}

