/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.plan.Plan;
import ix.test.PlanningTest;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.ParameterException;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.xml.XML;
import java.io.File;
import java.util.LinkedList;

public class FilePlanner
extends PlanningTest {
    protected String outputDirecoryName;
    protected String outputFileType;
    protected boolean testOnly;
    protected File domainFile;
    protected File planFile;
    protected File outputDirecoryFile;
    protected int numberOfPlans;
    protected int planNumber;

    public static void main(String[] stringArray) {
        Debug.off();
        try {
            Parameters.setIsInteractive(false);
            Parameters.processCommandLineArguments(stringArray);
            FilePlanner filePlanner = new FilePlanner();
            filePlanner.run();
        }
        catch (ParameterException parameterException) {
            System.out.println(Debug.describeException(parameterException));
            System.exit(1);
        }
    }

    protected void run() {
        this.setup();
        this.planNumber = 1;
        this.planner.plan();
        this.outputPlan(this.planner.getPlan());
        while (this.planNumber <= this.numberOfPlans) {
            this.planner.replan();
            this.outputPlan(this.planner.getPlan());
        }
    }

    protected void setup() {
        super.setup();
        this.numberOfPlans = Parameters.getInt("number-of-plans", 1);
        this.outputDirecoryName = Parameters.getParameter("output-directory");
        this.outputFileType = Parameters.getParameter("output-file-type");
        this.testOnly = Parameters.getBoolean("test", false);
        this.checkThatEnoughParametersWereGiven();
        if (this.domainName != null) {
            this.domainFile = new File(this.domainName);
        }
        if (this.planName != null) {
            this.planFile = new File(this.planName);
        }
        if (this.outputDirecoryName != null) {
            this.outputDirecoryFile = new File(this.outputDirecoryName);
        } else if (this.planFile != null) {
            this.outputDirecoryFile = this.planFile.getParentFile();
        } else if (this.domainFile != null) {
            this.outputDirecoryFile = this.domainFile.getParentFile();
        } else {
            throw new ConsistencyException("Can't determine output directory");
        }
        if (this.outputFileType == null) {
            this.outputFileType = this.planFile != null && this.planFile.getName().indexOf(".") > 0 ? Strings.afterLast(".", this.planFile.getName()) : "xml";
        }
    }

    protected void checkThatEnoughParametersWereGiven() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.domainName == null) {
            linkedList.add("a domain must be given");
        }
        if (this.task == null && this.planName == null) {
            linkedList.add("a task or an initial plan must be specified");
        }
        if (!linkedList.isEmpty()) {
            throw new ParameterException("Missing parameters: " + Strings.conjunction(linkedList));
        }
    }

    protected void outputPlan(Plan plan) {
        String string = this.savedPlanName();
        File file = new File(this.outputDirecoryFile, string);
        System.out.println("Have plan " + file);
        if (!this.testOnly) {
            XML.writeObject(plan, file.getPath());
        }
        ++this.planNumber;
    }

    protected String savedPlanName() {
        return this.namePart(this.domainFile) + "-" + Strings.replace(" ", "-", this.taskDescription()) + "-plan-" + this.planNumber + "." + this.outputFileType;
    }

    protected String namePart(File file) {
        return Strings.beforeLast(".", file.getName());
    }

    protected String taskDescription() {
        if (this.task != null) {
            return this.task;
        }
        String string = this.namePart(this.domainFile) + "-";
        String string2 = this.namePart(this.planFile);
        if (string2.startsWith(string)) {
            return "starting-from-" + Strings.afterFirst(string, string2);
        }
        return string2;
    }
}

