/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.xml.XML;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Document;

public class HttpGetDocumentTest {
    static final String dateTimePattern = "yyyy'-'MM'-'dd'T'HH'-'mm'-'ss'Z'";
    static final SimpleDateFormat format = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH'-'mm'-'ss'Z'");

    public HttpGetDocumentTest() {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        format.setLenient(false);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            Document document = XML.parseXML(XML.toURL(string));
            XML.makePrettyXMLOutputter().output(document, (OutputStream)System.out);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            HttpGetDocumentTest.writeErrorReport(exception);
        }
    }

    static void writeErrorReport(Exception exception) {
        Date date = new Date();
        String string = "http-get-error-" + format.format(date) + ".txt";
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            exception.printStackTrace(printWriter);
            printWriter.close();
        }
        catch (Exception exception2) {
            Debug.noteln("Cannot write error report");
            Debug.noteException(exception2);
        }
    }
}

