/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.lisp.Lisp;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class LongToBytes {
    private static final String DIGITS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ~_";
    private static final Map<Character, Integer> DIGIT_VALUE_TABLE = new HashMap<Character, Integer>();

    public static void main(String[] stringArray) {
        String string;
        while (!(string = Util.askLine("Long:")).equals("bye")) {
            Long l = (Long)Lisp.readFromString(string);
            long l2 = l;
            byte[] byArray = LongToBytes.longToBytes(l2);
            System.out.println(LongToBytes.printName(byArray));
            System.out.println("= " + LongToBytes.bytesToLong(byArray));
            System.out.println("= " + LongToBytes.bytesToLongStrings(byArray));
            System.out.println("= " + LongToBytes.encode(l2));
            System.out.println("= " + LongToBytes.decode(LongToBytes.encode(l2)));
            System.out.println("");
        }
        return;
    }

    static String printName(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("byte[").append(byArray.length).append("]{");
        for (int i = 0; i < byArray.length - 1; ++i) {
            stringBuffer.append(byArray[i]).append(", ");
        }
        stringBuffer.append(byArray[byArray.length - 1]).append("}");
        return stringBuffer.toString();
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 56;
        int n2 = 0;
        while (n >= 0) {
            long l2 = l >> n;
            byArray[n2] = (byte)(l2 & 0xFFL);
            n -= 8;
            ++n2;
        }
        return byArray;
    }

    public static long bytesToLong(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l <<= 8;
            l |= (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static String bytesToLongStrings(byte[] byArray) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (dataInputStream.available() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("/");
                }
                stringBuffer.append(LongToBytes.encode(dataInputStream.readLong()));
            }
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        return stringBuffer.toString();
    }

    public static String encode(long l) {
        Debug.expect(DIGITS.length() == 64);
        if (l == 0L) {
            return "0";
        }
        boolean bl = l < 0L;
        StringBuilder stringBuilder = new StringBuilder();
        BigInteger bigInteger = BigInteger.valueOf(l);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        BigInteger bigInteger3 = BigInteger.valueOf(64L);
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        while (bigInteger.compareTo(bigInteger2) > 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger3);
            int n = bigIntegerArray[1].intValue();
            stringBuilder.insert(0, DIGITS.charAt(n));
            bigInteger = bigIntegerArray[0];
        }
        if (bl) {
            stringBuilder.insert(0, "-");
        }
        return stringBuilder.toString();
    }

    public static long decode(String string) {
        Debug.expect(DIGITS.length() == 64);
        boolean bl = string.startsWith("-");
        int n = bl ? 1 : 0;
        int n2 = string.length();
        long l = 0L;
        while (n < n2) {
            char c;
            int n3;
            if ((n3 = DIGIT_VALUE_TABLE.get(Character.valueOf(c = string.charAt(n++))).intValue()) < 0) {
                throw new ConsistencyException("Can't decode digit " + c);
            }
            l = l * 64L + (long)n3;
        }
        return bl ? -l : l;
    }

    static {
        int n = DIGITS.length();
        for (int i = 0; i < n; ++i) {
            DIGIT_VALUE_TABLE.put(Character.valueOf(DIGITS.charAt(i)), i);
        }
    }
}

