/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.ip2.Ip2ModelManager;
import ix.test.PlainIp2;
import ix.util.Debug;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class MakeDistanceTable {
    static final Symbol TRANSPORT_DISTANCE = Symbol.intern("transport-distance");
    static final Symbol TYPE = Symbol.intern("type");
    List placeTypes = Lisp.elementsFromString("location airport hospital aircraft-carrier");

    MakeDistanceTable() {
    }

    void outputTable(Map map) {
        SortedSet sortedSet = this.findAllPlaces(map);
        this.println(";;; Distance table for " + sortedSet.size() + " places.");
        for (Object e : sortedSet) {
            for (Object e2 : sortedSet) {
                if (e == e2) continue;
                this.outputDistance(map, e, e2);
            }
        }
    }

    void outputDistance(Map map, Object object, Object object2) {
        Cons cons = Lisp.list(TRANSPORT_DISTANCE, object, object2);
        Cons cons2 = Lisp.list(TRANSPORT_DISTANCE, object2, object);
        Object v = map.get(cons);
        Object v2 = map.get(cons2);
        if (v != null) {
            if (v2 == v || v2 == null) {
                this.outDist(object, object2, v);
            } else {
                this.outDist(object, object2, v + " ;; or " + v2 + "?");
            }
        } else if (v2 != null) {
            this.outDist(object, object2, v2);
        } else {
            this.outDist(object, object2, "LONG");
        }
    }

    void outDist(Object object, Object object2, Object object3) {
        this.println("transport-distance " + object + " " + object2 + " = " + object3);
    }

    SortedSet findAllPlaces(Map map) {
        TreeSet<Symbol> treeSet = new TreeSet<Symbol>();
        for (Map.Entry entry : map.entrySet()) {
            LList lList = (LList)entry.getKey();
            Object v = entry.getValue();
            if (lList.get(0) != TYPE || !this.placeTypes.contains(v)) continue;
            Symbol symbol = (Symbol)lList.get(1);
            treeSet.add(symbol);
        }
        return treeSet;
    }

    void println(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Debug.off();
        PlainIp2 plainIp2 = new PlainIp2();
        plainIp2.mainStartup(stringArray);
        Ip2ModelManager ip2ModelManager = (Ip2ModelManager)plainIp2.getModelManager();
        Map map = ip2ModelManager.getWorldStateMap();
        new MakeDistanceTable().outputTable(map);
    }
}

