/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.Constraint;
import ix.icore.domain.TimeWindow;
import ix.iface.domain.LTF_Parser;
import ix.ip2.Ip2XMLConfig;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Duration;
import ix.util.EnumeratedValue;
import ix.util.Fn;
import ix.util.ListOf;
import ix.util.MinMax;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.SemiPrimitive;
import ix.util.StructuralEquality;
import ix.util.TypedList;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.ItemVar;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Null;
import ix.util.lisp.Symbol;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.InheritanceTree;
import ix.util.xml.XML;
import ix.util.xml.XMLConfig;
import ix.util.xml.XMLTranslator;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeRandomInstance {
    protected XMLConfig config = new Ip2XMLConfig();
    protected ClassSyntax syntax = this.config.defaultClassSyntax();
    protected List<Class> relevantClasses = this.config.xmlSyntaxClasses(this.syntax, Object.class);
    protected InheritanceTree inheritance = new InheritanceTree(this.relevantClasses);
    protected LTF_Parser ltfParser = new LTF_Parser();
    protected long randomSeed = -4775043618027098404L;
    protected Random random = new Random(this.randomSeed);
    protected String LOWER = "abcdefghijklmnopqrstuvwxyz";
    protected String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected String DIGITS = "0123456789";
    protected String ALPHABET = this.LOWER + this.LOWER + this.UPPER + this.DIGITS + "     " + ".,;:_?!";
    protected List<Class> randomObjectClasses = Arrays.asList(String.class, Long.class, Symbol.class, ItemVar.class);
    protected MinMax collectionSize = new MinMax(0L, 2L);

    public MakeRandomInstance randomize() {
        this.random.setSeed(System.currentTimeMillis());
        return this;
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        MakeRandomInstance makeRandomInstance = new MakeRandomInstance();
        StructuralEquality structuralEquality = new StructuralEquality();
        String string = Parameters.getParameter("xml-translator-class", "ix.util.xml.XMLTranslator");
        Class clazz = makeRandomInstance.config.defaultClassFinder().classForName(string);
        XMLTranslator xMLTranslator = (XMLTranslator)Util.makeInstance(clazz, makeRandomInstance.syntax);
        if (Parameters.haveParameter("collection-size")) {
            makeRandomInstance.collectionSize = new MinMax(Parameters.getParameter("collection-size"));
        }
        if (Parameters.getBoolean("randomize", false)) {
            makeRandomInstance.randomize();
        }
        String string2 = Parameters.getParameter("class");
        do {
            String string3;
            String string4 = string3 = string2 != null ? string2 : Util.askLine("Class name:");
            if (string3.equals("bye")) {
                return;
            }
            Class clazz2 = XML.config().defaultClassFinder().classForName(string3);
            Object t = makeRandomInstance.makeInstance(clazz2);
            String string5 = xMLTranslator.objectToXMLString(t);
            System.out.println(string5);
            Object object = xMLTranslator.objectFromXML(string5);
            Debug.expect(structuralEquality.equal(t, object), "instance and copy differ");
        } while (string2 == null);
    }

    public <T> T makeInstance(Class<T> clazz) {
        return (T)this._makeInstance(clazz);
    }

    private Object _makeInstance(Class clazz) {
        if (clazz == Object.class) {
            return this.makeObject();
        }
        ClassDescr classDescr = this.syntax.getClassDescr(clazz);
        if (classDescr.isPrimitive()) {
            return this.makePrimitive(clazz);
        }
        if (classDescr.isCollection()) {
            return this.makeCollection(clazz);
        }
        if (classDescr.isMap()) {
            return this.makeMap(clazz);
        }
        if (classDescr.isAbstract()) {
            return this.makeConcreteInstance(clazz);
        }
        if (clazz == Constraint.class) {
            return this.makeConstraint();
        }
        if (clazz == TimeWindow.class) {
            return this.makeTimeWindow();
        }
        if (classDescr.isStruct()) {
            return this.makeStruct(clazz);
        }
        if (classDescr.isInterface()) {
            throw new IllegalArgumentException("Instance class is interface: " + clazz);
        }
        return null;
    }

    protected Object makeConcreteInstance(Class clazz) {
        Debug.expect(Modifier.isAbstract(clazz.getModifiers()));
        List<Class> list = this.inheritance.getSubclasses(clazz);
        if (list == null) {
            throw new IllegalArgumentException("Instance class is abstract: " + clazz);
        }
        return this.makeInstance(this.randomth(list));
    }

    protected <E> E randomth(List<E> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    protected int randomIn(MinMax minMax) {
        return this.randomIn((int)minMax.getMin(), (int)minMax.getMax());
    }

    protected int randomIn(int n, int n2) {
        return n + this.random.nextInt(n2 - n + 1);
    }

    protected Object makeObject() {
        return this.makeInstance(this.randomth(this.randomObjectClasses));
    }

    protected Object makePrimitive(Class clazz) {
        if (clazz == String.class) {
            return this.makeMediumString();
        }
        if (SemiPrimitive.class.isAssignableFrom(clazz)) {
            return this.makeSemiPrimitive(clazz);
        }
        if ((clazz = Fn.objectClass(clazz)) == Boolean.class) {
            return this.random.nextBoolean();
        }
        if (clazz == Integer.class) {
            return this.random.nextInt();
        }
        if (clazz == Long.class) {
            return this.random.nextLong();
        }
        if (clazz == Float.class) {
            return Float.valueOf(this.random.nextFloat());
        }
        if (clazz == Double.class) {
            return this.random.nextDouble();
        }
        return null;
    }

    protected Object makeSemiPrimitive(Class clazz) {
        if (clazz == Symbol.class) {
            return Symbol.intern(this.makeShortString());
        }
        if (clazz == ItemVar.class) {
            return this.makeItemVar();
        }
        if (clazz == Name.class) {
            return this.makeName();
        }
        if (EnumeratedValue.class.isAssignableFrom(clazz)) {
            List list = (List)Fn.applyStatic(clazz, "values", new Object[0]);
            return this.randomth(list);
        }
        if (clazz == Duration.class) {
            return this.makeDuration();
        }
        throw new UnsupportedOperationException("Can't instantiate semiprimitive " + clazz);
    }

    public Name makeName() {
        return Name.valueOf(this.makeString(this.LOWER, this.randomIn(2, 6)));
    }

    public ItemVar makeItemVar() {
        return (ItemVar)Symbol.intern("?" + this.makeString(this.LOWER, 2));
    }

    public Duration makeDuration() {
        return new Duration(this.randomIn(0, 172800000));
    }

    public String makeShortString() {
        return this.makeString(this.ALPHABET, this.random.nextInt(5));
    }

    public String makeMediumString() {
        return this.makeString(this.ALPHABET, 5 + this.random.nextInt(10));
    }

    public String makeString(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string.length();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(this.random.nextInt(n2)));
        }
        return stringBuilder.toString();
    }

    public Collection makeCollection(Class clazz) {
        ClassDescr classDescr = this.syntax.getClassDescr(clazz);
        Class clazz2 = classDescr.getEltType() != null ? classDescr.getEltType().getDescribedClass() : Object.class;
        return this.makeCollection(clazz, clazz2);
    }

    public Collection makeCollection(Class clazz, Class clazz2) {
        Class clazz3 = this.determineImplClass(clazz);
        if (LList.class.isAssignableFrom(clazz3)) {
            return this.makeLList(clazz, clazz2);
        }
        Collection collection = (Collection)Util.makeInstance(clazz3);
        for (int i = this.randomIn(this.collectionSize); i > 0; --i) {
            collection.add(this.makeInstance(clazz2));
        }
        return collection;
    }

    protected Class determineImplClass(Class clazz) {
        if (clazz.isInterface()) {
            if (TypedList.class.isAssignableFrom(clazz)) {
                Class clazz2 = ListOf.findImplementationClass(clazz, LinkedList.class);
                if (clazz2 == null) {
                    throw new UnsupportedOperationException("Cannot find a linked implementation for " + clazz);
                }
                return clazz2;
            }
            if (clazz == List.class) {
                return LinkedList.class;
            }
            if (clazz == Set.class) {
                return LinkedHashSet.class;
            }
            if (clazz == Map.class) {
                return LinkedHashMap.class;
            }
            throw new UnsupportedOperationException("Don't know how to implement " + clazz);
        }
        return clazz;
    }

    public LList makeLList(Class clazz, Class clazz2) {
        if (clazz == Null.class) {
            return Lisp.NIL;
        }
        if (clazz == LList.class || clazz == Cons.class) {
            LListCollector lListCollector = (LListCollector)this.makeCollection(LListCollector.class, clazz2);
            return lListCollector.contents();
        }
        throw new UnsupportedOperationException("Cannot handle LList class " + clazz);
    }

    public Map makeMap(Class clazz) {
        Class clazz2 = this.determineImplClass(clazz);
        Map map = (Map)Util.makeInstance(clazz2);
        for (int i = this.randomIn(this.collectionSize); i > 0; --i) {
            map.put(this.makeObject(), this.makeObject());
        }
        return map;
    }

    protected Object makeStruct(Class clazz) {
        ClassDescr classDescr = this.syntax.getClassDescr(clazz);
        Object t = Util.makeInstance(clazz);
        for (FieldDescr fieldDescr : classDescr.getFieldDescrs()) {
            Object object = this.makeFieldValue(fieldDescr);
            try {
                fieldDescr.setValue(t, object);
            }
            catch (Exception exception) {
                throw new RethrownException("Can't set " + fieldDescr + " in " + clazz, exception);
            }
        }
        return t;
    }

    protected Object makeFieldValue(FieldDescr fieldDescr) {
        ClassDescr classDescr = fieldDescr.getTypeDescr();
        if (classDescr.isCollection() && classDescr.getEltType() != null) {
            return this.makeCollection(classDescr.getDescribedClass(), classDescr.getEltType().getDescribedClass());
        }
        return this.makeInstance(classDescr.getDescribedClass());
    }

    protected Constraint makeConstraint() {
        Vector vector = this.ltfParser.getConstraintParsers().getCases();
        LTF_Parser.ConstraintParser constraintParser = (LTF_Parser.ConstraintParser)this.randomth(vector);
        Constraint constraint = constraintParser.makeTemplate();
        Constraint constraint2 = new Constraint(constraint.getType(), constraint.getRelation(), this.makeConstraintParameters(constraint.getParameters()));
        constraint2.setAnnotations(constraint.getAnnotations());
        return constraint2;
    }

    protected List makeConstraintParameters(List list) {
        LinkedList linkedList = new LinkedList();
        for (Object e : list) {
            Class<?> clazz = e instanceof Class ? (Class<?>)e : e.getClass();
            linkedList.add(this.makeInstance(clazz));
        }
        return linkedList;
    }

    public TimeWindow makeTimeWindow() {
        switch (this.randomIn(0, 3)) {
            case 0: {
                return new TimeWindow(this.makeItemVar(), (Object)this.makeDuration());
            }
            case 1: {
                return new TimeWindow((Object)this.makeDuration(), this.makeItemVar());
            }
            case 2: {
                return new TimeWindow(this.makeItemVar(), this.makeItemVar());
            }
            case 3: {
                Duration duration = this.makeDuration();
                long l = duration.asMilliseconds();
                long l2 = l + (long)this.randomIn(0, (int)l);
                return new TimeWindow(duration, new Duration(l2));
            }
        }
        throw new ConsistencyException("case out of range");
    }
}

