/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Status;
import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.ListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.ip2.ActivityHandler;
import ix.ip2.AgendaItem;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.Ip2ModelManager;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.FailureException;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.match.MatchChoice;
import ix.util.match.MatchEnv;
import java.util.List;

public class MatchStateHandler
extends ActivityHandler {
    Symbol verb;
    static final Symbol S_COMMA = Symbol.intern(",");
    static final Symbol S_EQUAL = Symbol.intern("=");
    Ip2 ip2;

    public MatchStateHandler(Ip2 ip2) {
        this(ip2, "match-state");
    }

    public MatchStateHandler(Ip2 ip2, String string) {
        super("Match state");
        this.ip2 = ip2;
        this.verb = Symbol.intern(string);
    }

    public List getSyntaxList() {
        return (LList)Lisp.readFromString("((" + this.verb + " { (?pattern-item ...) [ = ?value ] } ...))");
    }

    public boolean appliesTo(AgendaItem agendaItem) {
        LList lList = agendaItem.getPattern();
        return lList.length() > 1 && lList.get(0) == this.verb && lList.get(1) instanceof List;
    }

    public void addHandlerActions(AgendaItem agendaItem) {
        agendaItem.addAction(new MatchStateAction(agendaItem));
    }

    protected ListOfConstraint commaSyntax(LList lList) {
        LListCollector lListCollector = new LListCollector(lList);
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        if (lListCollector.popElement() != this.verb) {
            throw new ConsistencyException("No match-state", lList);
        }
        while (!lListCollector.isEmpty()) {
            LList lList2 = lListCollector.popToAny(Lisp.list(S_COMMA, S_EQUAL));
            if (lList2.isEmpty()) {
                throw new IllegalArgumentException("Empty pattern before " + lListCollector.contents() + " in pattern " + lList);
            }
            if (lListCollector.isEmpty()) {
                linkedListOfConstraint.add(this.makeConstraint(lList2));
                continue;
            }
            if (lListCollector.firstElement() == S_COMMA) {
                lListCollector.popElement();
                linkedListOfConstraint.add(this.makeConstraint(lList2));
                continue;
            }
            if (lListCollector.firstElement() == S_EQUAL) {
                lListCollector.popElement();
                LList lList3 = lListCollector.popToAny(Lisp.list(S_COMMA));
                if (!lListCollector.isEmpty()) {
                    Debug.expect(lListCollector.popElement() == S_COMMA);
                }
                if (lList3.size() == 1) {
                    linkedListOfConstraint.add(this.makeConstraint(lList2, lList3.get(0)));
                    continue;
                }
                throw new IllegalArgumentException("More than one value for pattern " + lList2 + " in item pattern " + lList);
            }
            throw new IllegalArgumentException("Unexpected token " + lListCollector.firstElement() + " at start of " + lListCollector.contents() + " in " + lList);
        }
        return linkedListOfConstraint;
    }

    Constraint makeConstraint(LList lList) {
        return this.makeConstraint(lList, PatternAssignment.S_TRUE);
    }

    Constraint makeConstraint(LList lList, Object object) {
        return new Constraint(Refinement.S_WORLD_STATE, Refinement.S_CONDITION, (List)Lisp.list(new PatternAssignment(lList, object)));
    }

    protected ListOfConstraint parenSyntax(LList lList) {
        LListCollector lListCollector = new LListCollector(lList);
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        if (lListCollector.popElement() != this.verb) {
            throw new ConsistencyException("No match-state", lList);
        }
        while (!lListCollector.isEmpty()) {
            Object object = lListCollector.popElement();
            if (!(object instanceof Cons)) {
                throw new IllegalArgumentException("Illegal pattern before " + lListCollector.contents() + " in item pattern " + lList);
            }
            Cons cons = (Cons)object;
            if (lListCollector.isEmpty()) {
                linkedListOfConstraint.add(this.makeConstraint(cons));
                continue;
            }
            if (lListCollector.firstElement() == S_EQUAL) {
                lListCollector.popElement();
                Object object2 = lListCollector.popElement();
                linkedListOfConstraint.add(this.makeConstraint(cons, object2));
                continue;
            }
            linkedListOfConstraint.add(this.makeConstraint(cons));
        }
        return linkedListOfConstraint;
    }

    class MatchStateAction
    extends HandlerAction {
        AgendaItem item;
        ListOfConstraint conditions;

        MatchStateAction(AgendaItem agendaItem) {
            this.item = agendaItem;
            this.shortDescription = "Match world state";
            LList lList = agendaItem.getPattern();
            this.conditions = lList.contains(S_COMMA) ? MatchStateHandler.this.commaSyntax(lList) : MatchStateHandler.this.parenSyntax(lList);
            Debug.noteln("Parsed conditions", (Object)this.conditions);
        }

        public boolean isReady() {
            return true;
        }

        public void handle(AgendaItem agendaItem) {
            Debug.expect(agendaItem == this.item, "Wrong item");
            Debug.noteln("Conditions", (Object)this.conditions);
            Ip2ModelManager ip2ModelManager = (Ip2ModelManager)MatchStateHandler.this.ip2.getModelManager();
            List list = ip2ModelManager.evalFilters(this.conditions, new MatchEnv());
            if (list.isEmpty()) {
                throw new FailureException("Cannot match everything");
            }
            MatchChoice matchChoice = ip2ModelManager.addMatchChoice(list);
            agendaItem.setStatus(Status.COMPLETE);
        }
    }
}

