/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.End;
import ix.icore.domain.ListOfOrdering;
import ix.icore.domain.NodeEndRef;
import ix.icore.domain.Ordering;
import ix.iface.domain.LTF_Parser;
import ix.iface.domain.LTF_Writer;
import ix.util.Collect;
import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Name;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingNotationTest {
    public static void main(String[] stringArray) {
        LTF_Parser lTF_Parser = new LTF_Parser();
        LTF_Writer lTF_Writer = new LTF_Writer();
        while (true) {
            try {
                block3: while (true) {
                    String string;
                    if ((string = Util.askLines("\nOrderings:")).equals("bye") || string.equals("")) {
                        return;
                    }
                    LList lList = Lisp.elementsFromString(string);
                    LList lList2 = LTF_Parser.expandAllOrderings(lList);
                    System.out.println("Expansion: " + lList2);
                    ListOfOrdering listOfOrdering = lTF_Parser.makeOrderings(lList2);
                    List list = OrderingNotationTest.unexpandOrderings(listOfOrdering);
                    System.out.println("\nUnexpanded:\n");
                    Iterator iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        Object e = iterator.next();
                        System.out.println("   " + e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable);
                continue;
            }
            break;
        }
    }

    static List unexpandOrderings(List<Ordering> list) {
        ListIterator<Ordering> listIterator = list.listIterator();
        LinkedList<List> linkedList = new LinkedList<List>();
        while (listIterator.hasNext()) {
            OrderingNotationTest.unexpandFront(listIterator, linkedList);
        }
        return linkedList;
    }

    private static void unexpandFront(ListIterator<Ordering> listIterator, LinkedList<List> linkedList) {
        Debug.expect(listIterator.hasNext());
        Ordering ordering = listIterator.next();
        if (!listIterator.hasNext()) {
            OrderingNotationTest.addOrdering(linkedList, ordering);
            return;
        }
        Ordering ordering2 = listIterator.next();
        if (ordering.getFrom().equals(ordering2.getFrom())) {
            OrderingNotationTest.fanOut(ordering, ordering2, listIterator, linkedList);
        } else if (ordering.getTo().equals(ordering2.getTo())) {
            OrderingNotationTest.fanIn(ordering, ordering2, listIterator, linkedList);
        } else {
            OrderingNotationTest.addOrdering(linkedList, ordering);
            listIterator.previous();
        }
    }

    private static void fanOut(Ordering ordering, Ordering ordering2, ListIterator<Ordering> listIterator, LinkedList<List> linkedList) {
        Debug.expect(ordering.getFrom().equals(ordering2.getFrom()));
        NodeEndRef nodeEndRef = ordering.getFrom();
        List<NodeEndRef> list = Collect.makeList(ordering.getTo(), ordering2.getTo());
        while (listIterator.hasNext()) {
            Ordering ordering3 = listIterator.next();
            if (ordering3.getFrom().equals(nodeEndRef)) {
                list.add(ordering3.getTo());
                continue;
            }
            listIterator.previous();
            break;
        }
        OrderingNotationTest.addOrdering(linkedList, nodeEndRef, list);
    }

    private static void fanIn(Ordering ordering, Ordering ordering2, ListIterator<Ordering> listIterator, LinkedList<List> linkedList) {
        Debug.expect(ordering.getTo().equals(ordering2.getTo()));
        NodeEndRef nodeEndRef = ordering.getTo();
        List<NodeEndRef> list = Collect.makeList(ordering.getFrom(), ordering2.getFrom());
        while (listIterator.hasNext()) {
            Ordering ordering3 = listIterator.next();
            if (ordering3.getTo().equals(nodeEndRef)) {
                list.add(ordering3.getFrom());
                continue;
            }
            listIterator.previous();
            break;
        }
        OrderingNotationTest.addOrdering(linkedList, list, nodeEndRef);
    }

    private static void addOrdering(LinkedList<List> linkedList, Ordering ordering) {
        OrderingNotationTest.addOrdering(linkedList, ordering.getFrom(), ordering.getTo());
    }

    private static void addOrdering(LinkedList<List> linkedList, Object object, Object object2) {
        object = OrderingNotationTest.orderingElementNotation(object, End.END);
        object2 = OrderingNotationTest.orderingElementNotation(object2, End.BEGIN);
        Debug.noteln("Adding " + object + " --> " + object2);
        if (linkedList.isEmpty()) {
            linkedList.add(Collect.makeList(object, object2));
        } else {
            List list = linkedList.getLast();
            Object e = Collect.lastElement(list);
            if (e.equals(object)) {
                list.add(object2);
            } else {
                linkedList.add(Collect.makeList(object, object2));
            }
        }
    }

    private static Object orderingElementNotation(Object object, End end) {
        if (object instanceof NodeEndRef) {
            return OrderingNotationTest.nodeEndNotation((NodeEndRef)object, end);
        }
        if (object instanceof List) {
            LinkedList linkedList = new LinkedList((List)object);
            ListIterator<Name> listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                NodeEndRef nodeEndRef = Util.mustBe(NodeEndRef.class, listIterator.next());
                listIterator.set(OrderingNotationTest.nodeEndNotation(nodeEndRef, end));
            }
            return linkedList;
        }
        throw new ConsistencyException("Bad ordering element", object);
    }

    private static Name nodeEndNotation(NodeEndRef nodeEndRef, End end) {
        if (nodeEndRef.getEnd() == end) {
            return nodeEndRef.getNode();
        }
        return Name.valueOf((nodeEndRef.getEnd() == End.BEGIN ? "b/" : "e/") + nodeEndRef.getNode());
    }
}

