/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.icore.domain.Domain;
import ix.icore.plan.Plan;
import ix.icore.plan.build.SimplePlanBuilder;
import ix.iplan.IPlan;
import ix.iplan.NoPlanException;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.Planner;
import ix.iplan.Slip;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;

public class PlanningTest {
    protected String domainName;
    protected String planName;
    protected String task;
    protected Planner planner;
    protected Domain domain;

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.processCommandLineArguments(stringArray);
        PlanningTest planningTest = new PlanningTest();
        planningTest.run();
    }

    protected void run() {
        this.setup();
        try {
            this.planner.plan();
            while (true) {
                this.planner.getStatistics().report(System.out);
                this.checkPlan();
                if (Util.askLine("Replan?").trim().startsWith("y")) {
                    this.planner.replan();
                    continue;
                }
                System.exit(0);
            }
        }
        catch (NoPlanException noPlanException) {
            System.out.println("No plan.");
        }
        catch (Slip.StepLimitException stepLimitException) {
            System.out.println(Debug.describeException(stepLimitException));
        }
        if (!Debug.isOn()) {
            this.planner.getStatistics().report(System.out);
        }
        System.exit(1);
    }

    protected void setup() {
        this.domainName = Parameters.getParameter("domain");
        this.planName = Parameters.getParameter("plan");
        this.task = Parameters.getParameter("task");
        this.planner = IPlan.makeDefaultPlanner();
        if (this.domainName != null) {
            this.domain = XML.readObject(Domain.class, this.domainName);
            this.planner.setDomain(this.domain);
        }
        if (this.planName != null) {
            this.planner.loadPlan(XML.readObject(Plan.class, this.planName));
        }
        if (this.task != null) {
            this.planner.loadPlan(this.initialPlan(this.task));
        }
    }

    protected Plan initialPlan(String string) {
        SimplePlanBuilder simplePlanBuilder = new SimplePlanBuilder();
        LList lList = Lisp.elementsFromString(string);
        simplePlanBuilder.addActivity(new Activity(lList));
        return simplePlanBuilder.getPlan();
    }

    protected void checkPlan() {
        PlanCheckingSimulator planCheckingSimulator = new PlanCheckingSimulator(this.planner.getPlan(), this.domain);
        planCheckingSimulator.processCommandLineArguments();
        planCheckingSimulator.run();
        planCheckingSimulator.report();
        if (Parameters.getBoolean("trace", true)) {
            planCheckingSimulator.describeChangedWorldState();
        }
    }
}

