/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.Constraint;
import ix.icore.domain.LinkedListOfConstraint;
import ix.icore.domain.PatternAssignment;
import ix.icore.domain.Refinement;
import ix.iplan.Slip;
import ix.test.BlockStacker;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import ix.util.xml.XML;
import java.util.Collections;
import java.util.List;

public class PrecondBlockStacker
extends BlockStacker {
    public PrecondBlockStacker(String string) {
        super(string);
    }

    protected String getDefaultBaseDomainName() {
        return "test-domains/blocks-using-achieve-1.lsp";
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        String string = Parameters.getParameter("output");
        String string2 = Parameters.getParameter("problem");
        Debug.expect(string2 != null, "No problem specified");
        PrecondBlockStacker precondBlockStacker = new PrecondBlockStacker(string2);
        precondBlockStacker.findPlan();
        while (true) {
            precondBlockStacker.checkPlan();
            if (string != null) {
                XML.writeObject(precondBlockStacker.getPlan(), string);
            }
            if (Util.askLine("Replan?").trim().startsWith("y")) {
                precondBlockStacker.replan();
                continue;
            }
            System.exit(0);
        }
    }

    protected Refinement initialStateRefinement(List list) {
        Refinement refinement = super.initialStateRefinement(list);
        refinement.setAnnotation(Symbol.intern("use-for-world-state-effects"), Symbol.intern(":none"));
        return refinement;
    }

    protected Refinement goalStateRefinement(List list) {
        boolean bl = Slip.domainUsesConditionTypes(this.baseDomain);
        Refinement refinement = new Refinement("problem-goal", this.pattern("(problem-goal)"));
        LinkedListOfConstraint linkedListOfConstraint = new LinkedListOfConstraint();
        for (List list2 : list) {
            List list3 = this.towerPatterns(list2);
            Collections.reverse(list3);
            for (LList lList : list3) {
                Constraint constraint = new Constraint("world-state", "condition", (List)Lisp.list(new PatternAssignment(lList)));
                if (bl) {
                    constraint.setAnnotation(Slip.S_CONDITION_TYPE, Slip.S_ACHIEVE);
                }
                linkedListOfConstraint.add(constraint);
            }
        }
        refinement.setConstraints(linkedListOfConstraint);
        return refinement;
    }
}

