/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.End;
import ix.icore.process.PNodeEnd;
import ix.test.BlockStacker;
import ix.util.Collect;
import ix.util.Util;
import ix.util.lisp.Cons;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBlockSim {
    LList initialTowers;
    LList finalTowers;
    LList towers;

    public SimpleBlockSim(List list, List list2) {
        this.initialTowers = LList.LListify(list);
        this.finalTowers = LList.LListify(list2);
        this.towers = this.initialTowers;
    }

    public SimpleBlockSim(BlockStacker blockStacker) {
        this(blockStacker.getInitialTowers(), blockStacker.getFinalTowers());
    }

    public LList getTowers() {
        return this.towers;
    }

    public boolean isFinished() {
        return Collect.equalAsSets(this.towers, this.finalTowers);
    }

    public void simulatePlan(List<PNodeEnd> list) {
        for (PNodeEnd pNodeEnd : list) {
            Symbol symbol;
            if (pNodeEnd.getEnd() != End.BEGIN) continue;
            LList lList = pNodeEnd.getNode().getPattern();
            String string = lList.get(0).toString();
            if (string.equals("move")) {
                symbol = Util.mustBe(Symbol.class, lList.get(1));
                Symbol symbol2 = Util.mustBe(Symbol.class, lList.get(2));
                this.moveBlock(symbol, symbol2);
                continue;
            }
            if (!string.equals("move-to-table")) continue;
            symbol = Util.mustBe(Symbol.class, lList.get(1));
            this.moveToTable(symbol);
        }
    }

    public void moveBlock(Symbol symbol, Symbol symbol2) {
        LListCollector lListCollector = new LListCollector();
        boolean bl = false;
        boolean bl2 = false;
        for (LList lList : this.towers) {
            Symbol symbol3 = (Symbol)lList.car();
            if (symbol3 == symbol) {
                bl = true;
                LList lList2 = lList.cdr();
                if (lList2.isEmpty()) continue;
                lListCollector.add(lList2);
                continue;
            }
            if (symbol3 == symbol2) {
                bl2 = true;
                lListCollector.add(new Cons(symbol, lList));
                continue;
            }
            lListCollector.add(lList);
        }
        if (!bl || !bl2) {
            throw new IllegalStateException("Could not find" + (bl ? " " : " from " + symbol) + (bl2 ? "" : " to " + symbol2));
        }
        this.towers = lListCollector.contents();
    }

    public void moveToTable(Symbol symbol) {
        LListCollector lListCollector = new LListCollector();
        boolean bl = false;
        for (LList lList : this.towers) {
            Symbol symbol2 = (Symbol)lList.car();
            if (symbol2 == symbol) {
                bl = true;
                LList lList2 = lList.cdr();
                if (!lList2.isEmpty()) {
                    lListCollector.add(lList2);
                }
                lListCollector.add(Lisp.list(symbol));
                continue;
            }
            lListCollector.add(lList);
        }
        if (!bl) {
            throw new IllegalStateException("Could not find " + symbol + " to move to table");
        }
        this.towers = lListCollector.contents();
    }
}

