/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.Activity;
import ix.ip2.ActivityItem;
import ix.ip2.CompletionHandler;
import ix.ip2.ExpandHandler;
import ix.ip2.HandlerAction;
import ix.ip2.Ip2;
import ix.ip2.PanelController;
import ix.ip2.ShowURLHandler;
import ix.util.Debug;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SimpleExpandingSimulator
extends Ip2 {
    protected PrintStream traceOut = Debug.out;
    protected boolean trace = true;

    public SimpleExpandingSimulator() {
        this(true);
    }

    protected SimpleExpandingSimulator(boolean bl) {
        super(bl);
        this.agentTypeName = "Simple I-Sim";
        this.logoLine1 = "Simple I-Sim";
        this.displayName = this.agentTypeName;
    }

    public static void main(String[] stringArray) {
        Util.printGreeting("Simple Expanding Simulator");
        SimpleExpandingSimulator simpleExpandingSimulator = new SimpleExpandingSimulator();
        simpleExpandingSimulator.mainStartup(stringArray);
        while (true) {
            simpleExpandingSimulator.getPatternsAndRun();
        }
    }

    public void completeStartup() {
        super.completeStartup();
    }

    public SimController getSimController() {
        return (SimController)this.getController();
    }

    protected PanelController makeController() {
        return new SimController(this);
    }

    protected void addHandlers() {
        this.controller.addItemHandler(new CompletionHandler(this));
        this.controller.addActivityHandler(new ExpandHandler(this));
        this.controller.addActivityHandler(new ShowURLHandler(this));
    }

    void getPatternsAndRun() {
        String string;
        System.out.println("\nEnter patterns one per line ending with a blank line.");
        LinkedList<LList> linkedList = new LinkedList<LList>();
        while (!(string = Util.askLine(">").trim()).equals("")) {
            linkedList.add(Lisp.elementsFromString(string));
        }
        this.simulateExecution(linkedList);
    }

    synchronized void simulateExecution(List list) {
        Object object2;
        LinkedList<Activity> linkedList = new LinkedList<Activity>();
        for (Object object2 : list) {
            linkedList.add(new Activity((LList)object2));
        }
        List list2 = this.getSimController().addActivities(linkedList);
        object2 = list2.iterator();
        while (object2.hasNext()) {
            ActivityItem activityItem = (ActivityItem)object2.next();
            this.getSimController().execute(activityItem);
        }
    }

    protected static class SimController
    extends PanelController {
        SimpleExpandingSimulator sim;

        SimController(SimpleExpandingSimulator simpleExpandingSimulator) {
            super(simpleExpandingSimulator);
            this.sim = simpleExpandingSimulator;
        }

        public List addActivities(List list) {
            LinkedList<ActivityItem> linkedList = new LinkedList<ActivityItem>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                linkedList.add(this.addActivity((Activity)iterator.next()));
            }
            return linkedList;
        }

        public void execute(ActivityItem activityItem) {
            Debug.noteln("Trying to execute", (Object)activityItem);
            HandlerAction handlerAction = null;
            for (HandlerAction handlerAction2 : activityItem.getActions()) {
                if (!activityItem.actionCanBeTakenNow(handlerAction2) || handlerAction2 instanceof HandlerAction.NoAction) continue;
                if (handlerAction == null) {
                    handlerAction = handlerAction2;
                    continue;
                }
                if (!(handlerAction2 instanceof ExpandHandler.ExpandAction)) continue;
                if (handlerAction instanceof ExpandHandler.ExpandAction) {
                    throw new IllegalStateException("More than one way to expand " + activityItem);
                }
                handlerAction = handlerAction2;
            }
            if (handlerAction == null) {
                throw new IllegalStateException("Cannot execute " + activityItem);
            }
            this.getActivityAgenda().handleItem(activityItem, handlerAction);
        }
    }
}

