/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.RethrownIOException;
import ix.util.Strings;
import ix.util.http.HttpRequestException;
import ix.util.http.HttpStringClient;
import ix.util.xml.XML;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterAtomSearchTest {
    String SEARCH_URL = "http://search.twitter.com/search.atom";
    String DEFAULT_QUERY = "#openvce";
    int MAX_RESULTS = 10;
    int CONNECT_TIMEOUT = 90000;
    int READ_TIMEOUT = 90000;
    Namespace ATOM_NAMESPACE = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    Namespace TWITTER_NAMESPACE = Namespace.getNamespace((String)"twitter", (String)"http://api.twitter.com/");
    String dateTimePattern = "yyyy'-'MM'-'dd'_'HH'-'mm'-'ss";
    SimpleDateFormat format = new SimpleDateFormat(this.dateTimePattern);

    public TwitterAtomSearchTest() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format.setLenient(false);
    }

    public static void main(String[] stringArray) throws IOException {
        new TwitterAtomSearchTest().do_main(stringArray);
    }

    void do_main(String[] stringArray) {
        Document document;
        String string;
        Debug.off();
        String string2 = this.getEncodedQueryArgs();
        Map<String, List<String>> map = this.decodeQueryArgs(string2);
        try {
            string = map.get("q").get(0);
            if (string.trim().equals("")) {
                System.out.println("No search query was given.");
                return;
            }
            document = this.readResultXML(string);
        }
        catch (Exception exception) {
            this.writeErrorReport(exception);
            return;
        }
        string = document.getRootElement();
        ElementFilter elementFilter = new ElementFilter("entry");
        int n = 0;
        Iterator iterator = string.getContent((Filter)elementFilter).iterator();
        while (iterator.hasNext() && ++n <= this.MAX_RESULTS) {
            Element element = (Element)iterator.next();
            System.out.println(this.getAuthorName(element) + ": " + this.getContentText(element));
        }
    }

    String getAuthorName(Element element) {
        Element element2 = element.getChild("author", this.ATOM_NAMESPACE);
        Element element3 = element2.getChild("name", this.ATOM_NAMESPACE);
        return element3.getText();
    }

    String getContentText(Element element) {
        Element element2 = element.getChild("content", this.ATOM_NAMESPACE);
        return this.stripMarkup(element2.getTextNormalize());
    }

    String stripMarkup(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c != '>') continue;
                bl = false;
                continue;
            }
            if (c == '<') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    String getEncodedQueryArgs() {
        String string = System.getenv("QUERY_STRING");
        if (string != null && !string.equals("")) {
            return string;
        }
        try {
            return "q=" + URLEncoder.encode(this.DEFAULT_QUERY, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RethrownIOException(unsupportedEncodingException);
        }
    }

    Map<String, List<String>> decodeQueryArgs(String string) {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (String string2 : Strings.breakAt("&", string)) {
            String[] stringArray = Strings.breakAtFirst("=", string2);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            LinkedList<String> linkedList = (LinkedList<String>)linkedHashMap.get(string3);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                linkedHashMap.put(string3, linkedList);
            }
            linkedList.add(string4);
        }
        return linkedHashMap;
    }

    Document readResultXML(String string) throws Exception {
        File file = new File("cache/query_" + string);
        if (file.exists()) {
            long l = file.lastModified();
            Debug.noteln("Cached date", (Object)new Date(l));
            if (new Date().getTime() - l < 120000L) {
                Debug.noteln("Reading cached result");
                return XML.parseXML(file);
            }
            Debug.noteln("Cached result is too old");
        }
        SearchClient searchClient = new SearchClient();
        String string2 = this.SEARCH_URL + "?q=" + string;
        String string3 = searchClient.sendGetRequest(new URL(string2));
        File file2 = File.createTempFile("new_" + string, ".tmp", new File("cache/"));
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(string3);
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
        if (file.exists()) {
            file.delete();
        }
        file2.renameTo(file);
        return XML.parseXML(string3);
    }

    void writeErrorReport(Exception exception) {
        Date date = new Date();
        String string = "tmp/http-get-error-" + this.format.format(date) + ".txt";
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            exception.printStackTrace(printWriter);
            printWriter.close();
        }
        catch (Exception exception2) {
            Debug.noteln("Cannot write error report");
            Debug.noteException(exception2);
        }
    }

    private class SearchClient
    extends HttpStringClient {
        private SearchClient() {
            this.setConnectTimeout(TwitterAtomSearchTest.this.CONNECT_TIMEOUT);
            this.setReadTimeout(TwitterAtomSearchTest.this.READ_TIMEOUT);
        }

        protected boolean handleResponseCode(HttpURLConnection httpURLConnection) throws HttpRequestException, IOException {
            int n = httpURLConnection.getResponseCode();
            String string = httpURLConnection.getResponseMessage();
            if (n == 503) {
                throw new HttpRequestException(n, string + " Headers: " + httpURLConnection.getHeaderFields());
            }
            return this.handleResponseCode(n, string);
        }
    }
}

