/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.xml.XML;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class ValidateXml {
    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: validate-xml SCHEMA DOC");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        Schema schema = ValidateXml.makeSchema(string);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(string2));
        }
        catch (Exception exception) {
            System.out.println(Debug.describeException(exception));
        }
    }

    static Schema makeSchema(String string) {
        String string2;
        String string3 = Strings.afterLast(".", string);
        String string4 = string3.equals("xsd") ? "http://www.w3.org/2001/XMLSchema" : (string2 = string3.equals("rng") ? "http://relaxng.org/ns/structure/1.0" : null);
        if (string2 == null) {
            System.out.println("Could not determine schema language for " + string);
            System.exit(2);
        }
        try {
            return SchemaFactory.newInstance(string2).newSchema(XML.toURL(string));
        }
        catch (SAXException sAXException) {
            throw new RethrownException(sAXException);
        }
    }
}

