/*
 * Decompiled with CFR 0.152.
 */
package ix.test.xml;

import ix.icore.domain.Domain;
import ix.icore.domain.End;
import ix.icore.plan.Plan;
import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.ip2.Ip2ModelManager;
import ix.iplan.AutoTester;
import ix.iplan.ExecutionStages;
import ix.iplan.PlanCheckingSimulator;
import ix.iplan.PlanTest;
import ix.iplan.Slip;
import ix.test.BlockStacker;
import ix.test.HtnBlockStacker;
import ix.test.PrecondBlockStacker;
import ix.test.SimpleBlockSim;
import ix.util.Debug;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BlockStackingTest
extends PlanTest {
    String problem;

    public String getProblem() {
        return this.problem;
    }

    public void setProblem(String string) {
        this.problem = string;
    }

    public void setTask(String string) {
        throw new UnsupportedOperationException();
    }

    public void setInitialPlan(String string) {
        throw new UnsupportedOperationException();
    }

    public String testDescription() {
        return "Domain " + this.getDomain() + ", Problem " + this.getProblem();
    }

    public String taskDescription() {
        return this.getProblem();
    }

    public AutoTester.TestRunner makeTestRunner(AutoTester autoTester) {
        return new BlockTestRunner(this, autoTester);
    }

    static class BlockTestRunner
    extends AutoTester.TestRunner {
        AutoTester auto;
        BlockStacker stacker;
        BlockStackingTest test;

        BlockTestRunner(BlockStackingTest blockStackingTest, AutoTester autoTester) {
            AutoTester autoTester2 = autoTester;
            autoTester2.getClass();
            super(blockStackingTest);
            this.auto = autoTester;
            this.test = blockStackingTest;
        }

        protected Domain readDomain() {
            Domain domain = super.readDomain();
            this.stacker = this.makeBlockStacker(domain);
            Domain domain2 = this.stacker.problemDomain();
            domain2.takeFrom(domain);
            return domain2;
        }

        private BlockStacker makeBlockStacker(Domain domain) {
            BlockStacker blockStacker = domain.getAnnotation(Slip.S_ACHIEVABLE_CONDS) == Slip.K_NONE ? new HtnBlockStacker(this.test.getProblem()) : new PrecondBlockStacker(this.test.getProblem());
            blockStacker.setBaseDomain(domain);
            return blockStacker;
        }

        protected Plan initialPlan() {
            return this.stacker.initialPlan();
        }

        protected void checkPlan(Slip slip) {
            this.checkBlockStackingMoves(slip);
            super.checkPlan(slip);
        }

        protected Map runSimulation(PlanCheckingSimulator planCheckingSimulator) {
            Map map = super.runSimulation(planCheckingSimulator);
            List list = this.stacker.failedGoalPatterns(planCheckingSimulator.getWorldStateMap());
            if (!list.isEmpty()) {
                this.auto.testFailure(this.test, "False patterns " + list);
            } else {
                this.auto.traceln("World state is correct");
            }
            this.runSimpleBlockSim(planCheckingSimulator);
            return map;
        }

        protected void runSimpleBlockSim(PlanCheckingSimulator planCheckingSimulator) {
            SimpleBlockSim simpleBlockSim = new SimpleBlockSim(this.stacker);
            simpleBlockSim.simulatePlan(planCheckingSimulator.getExecutionOrder());
            if (simpleBlockSim.isFinished()) {
                this.auto.traceln("Block-moving simulation succeeded");
            } else {
                this.auto.testFailure(this.test, "block-moving simulation failed");
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void checkBlockStackingMoves(Slip slip) {
            Ip2ModelManager ip2ModelManager = slip.getIp2ModelManager();
            List<PNodeEnd> list = ip2ModelManager.getNodeEnds();
            List<List<PNodeEnd>> list2 = new ExecutionStages(list).getStages();
            LinkedList<String> linkedList = new LinkedList<String>();
            PNode pNode = null;
            PNodeEnd pNodeEnd = null;
            for (List<PNodeEnd> object : list2) {
                Object var10_13 = null;
                for (PNodeEnd pNodeEnd2 : object) {
                    LList lList = pNodeEnd2.getNode().getPattern();
                    if (!lList.get(0).toString().startsWith("move")) continue;
                    if (pNodeEnd2.getEnd() == End.BEGIN) {
                        PNode pNode2;
                        void var10_12;
                        if (var10_12 == null) {
                            PNodeEnd pNodeEnd3 = pNodeEnd2;
                        } else {
                            linkedList.add(this.twoMovesBeginInSameStage((PNodeEnd)var10_12, pNodeEnd2));
                        }
                        if (pNodeEnd == null) {
                            pNodeEnd = pNodeEnd2;
                        } else {
                            linkedList.add(this.overlappingMoves(pNodeEnd, pNodeEnd2));
                        }
                        if (pNode == null || !this.movingSameBlock(pNode, pNode2 = pNodeEnd2.getNode())) continue;
                        linkedList.add(this.blockMovedTwice(pNode, pNode2));
                        continue;
                    }
                    Debug.expect(pNodeEnd2.getEnd() == End.END);
                    Debug.expect(pNodeEnd != null, "missing move begin");
                    if (pNodeEnd == pNodeEnd2.getOtherNodeEnd()) {
                        pNode = pNodeEnd.getNode();
                        pNodeEnd = null;
                        continue;
                    }
                    linkedList.add(this.moveEndsMismatch(pNodeEnd, pNodeEnd2));
                }
            }
            if (!linkedList.isEmpty()) {
                int n = linkedList.size();
                this.auto.trace("block-move check finds ");
                this.auto.traceln(n == 1 ? "1 problem:" : n + " problems:");
                for (String string : linkedList) {
                    this.auto.traceln("   ", string);
                }
                this.auto.testFailure(this.test, "problems in block moves");
            }
        }

        private boolean movingSameBlock(PNode pNode, PNode pNode2) {
            return this.getBlockMoved(pNode) == this.getBlockMoved(pNode2);
        }

        private Symbol getBlockMoved(PNode pNode) {
            return (Symbol)pNode.getPattern().get(1);
        }

        private String twoMovesBeginInSameStage(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
            return "two moves begin in same stage: " + pNodeEnd.getNode() + " and " + pNodeEnd2.getNode();
        }

        private String overlappingMoves(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
            return "overlapping moves " + pNodeEnd.getNode() + " and " + pNodeEnd2.getNode();
        }

        private String blockMovedTwice(PNode pNode, PNode pNode2) {
            return "block moved twice in a row by " + pNode + " and " + pNode2;
        }

        private String moveEndsMismatch(PNodeEnd pNodeEnd, PNodeEnd pNodeEnd2) {
            return "mismatched ends " + pNodeEnd + " and " + pNodeEnd2;
        }
    }
}

