/*
 * Decompiled with CFR 0.152.
 */
package ix.test.xml;

import ix.icore.IXAgent;
import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.test.xml.WorldStateView;
import ix.util.Debug;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.Lisp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorldStateExport
extends WorldStateView {
    protected String destination;

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public void handleStateChange(Map map, IXAgent iXAgent) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            PatternAssignment patternAssignment = new PatternAssignment(iterator.next());
            if (!this.isIncluded(patternAssignment)) continue;
            Debug.noteln("Will send " + patternAssignment + " to " + this.destination);
            Constraint constraint = new Constraint("world-state", "effect", (List)Lisp.list(patternAssignment));
            this.send(iXAgent, constraint);
        }
    }

    void send(IXAgent iXAgent, Constraint constraint) {
        Name name = Name.valueOf(iXAgent.getAgentIPCName());
        constraint.setSenderId(name);
        IPC.sendObject(this.destination, constraint);
    }
}

