/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.AssertionFailure;
import ix.util.Fn1;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.Warning;
import java.awt.Component;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.SyncFailedException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Debug {
    public static boolean on = true;
    public static PrintStream out = System.out;
    private static FileDescriptor outFD = FileDescriptor.out;
    public static boolean noteThreads = false;
    public static boolean noteCaller = false;
    private static Component mainAgentFrame = null;
    private static volatile Fn1<Throwable, String> exceptionDescriber = null;

    private Debug() {
    }

    public static boolean on() {
        return Debug.setDebug(true);
    }

    public static boolean off() {
        return Debug.setDebug(false);
    }

    public static synchronized boolean isOn() {
        return on;
    }

    public static synchronized boolean setDebug(boolean bl) {
        boolean bl2 = on;
        on = bl;
        return bl2;
    }

    public static synchronized void recordMainFrame(Component component) {
        mainAgentFrame = component;
    }

    public static void setExceptionDescriber(Fn1<Throwable, String> fn1) {
        exceptionDescriber = fn1;
    }

    public static synchronized void processParameter(String string, String string2) {
        if (string.equals("debug")) {
            on = Parameters.getBoolean("debug", on);
        } else if (string.equals("interactive")) {
            Parameters.setIsInteractive(Parameters.getBoolean("interactive"));
        }
    }

    public static void note(String string) {
        if (on) {
            Debug.printNote(string);
        }
    }

    public static void noteln(String string) {
        if (on) {
            Debug.printlnNote(string);
        }
    }

    public static void noteln(String string, Object object) {
        if (on) {
            Debug.printlnNote(string + " " + object);
        }
    }

    public static void noteln(Object object, Object object2) {
        if (on) {
            Debug.printlnNote(object + " " + object2);
        }
    }

    public static void noteln(String string, int n) {
        if (on) {
            Debug.printlnNote(string + " " + n);
        }
    }

    public static void noteln(String string, boolean bl) {
        if (on) {
            Debug.printlnNote(string + " " + bl);
        }
    }

    public static synchronized void notelines(String[] stringArray) {
        if (on) {
            for (int i = 0; i < stringArray.length; ++i) {
                Debug.printlnNote(stringArray[i]);
            }
        }
    }

    public static void forceln(String string) {
        Debug.printlnNote(string);
    }

    private static synchronized void printNote(String string) {
        out.print(string);
        out.flush();
        Debug.outSync();
    }

    private static void outSync() {
        if (outFD != null) {
            try {
                outFD.sync();
            }
            catch (SyncFailedException syncFailedException) {
                outFD = null;
                Debug.noteln("Debug sync failed.");
            }
        }
    }

    private static synchronized void printlnNote(String string) {
        String string2 = "";
        if (noteThreads) {
            string2 = Thread.currentThread().getName() + ": ";
        }
        if (noteCaller) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                String string3;
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                String string4 = stackTraceElement.getClassName();
                if (string4.equals("ix.util.Debug") || (string3 = stackTraceElement.getMethodName()).equals("getStackTrace") && string4.equals("java.lang.Thread")) continue;
                string2 = string2 + string4 + "." + string3 + ": ";
                break;
            }
        }
        out.println(string2 == "" ? string : string2 + string);
        out.flush();
        Debug.outSync();
    }

    public static synchronized void setNoteStream(PrintStream printStream) {
        out = printStream;
        outFD = null;
    }

    public static synchronized void setNoteFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            out = new PrintStream(fileOutputStream, true);
            outFD = fileOutputStream.getFD();
        }
        catch (IOException iOException) {
            Debug.warn("Failed to setNoteFile to \"" + string + "\"\n" + "because " + iOException + "\n" + "so switching to System.out.");
            out = System.out;
            outFD = FileDescriptor.out;
        }
    }

    public static synchronized void noteException(Throwable throwable) {
        Debug.noteException(throwable, true);
    }

    public static synchronized void noteException(Throwable throwable, boolean bl) {
        String string;
        try {
            string = Debug.describeException(throwable);
        }
        catch (Throwable throwable2) {
            string = throwable.toString();
        }
        if (on) {
            Debug.noteln("\nException:", (Object)string);
            if (bl) {
                throwable.printStackTrace(out);
            }
            Debug.noteln("");
        }
        if (!on || out != System.out) {
            if (noteThreads) {
                System.err.println("\n" + Thread.currentThread().getName() + ": Exception: " + string);
            } else {
                System.err.println("\nException: " + string);
            }
            if (bl) {
                throwable.printStackTrace(System.err);
            }
            System.err.println("");
        }
    }

    public static void displayException(Throwable throwable) {
        Debug.displayException(null, throwable);
    }

    public static void displayException(final String string, final Throwable throwable) {
        if (string != null) {
            Debug.note(string + ": ");
        }
        Debug.noteException(throwable);
        if (!Parameters.isInteractive()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Debug.do_displayException(string, throwable);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Debug.do_displayException(string, throwable);
                    }
                });
            }
            catch (Throwable throwable2) {
                Debug.noteln("Exception in displayException method");
                Debug.noteException(throwable2);
            }
        }
    }

    private static void do_displayException(String string, Throwable throwable) {
        String string2 = (string == null ? "" : string + ": ") + Debug.describeException(throwable);
        JOptionPane.showMessageDialog(Debug.probableMainFrame(), new Object[]{Strings.foldLongLine(string2)}, "Exception", 0);
    }

    public static synchronized Component probableMainFrame() {
        return mainAgentFrame;
    }

    public static String describeException(Throwable throwable) {
        if (exceptionDescriber != null) {
            return exceptionDescriber.funcall(throwable);
        }
        return Debug.defaultDescribeException(throwable);
    }

    public static String defaultDescribeException(Throwable throwable) {
        String string = throwable.getClass().getName();
        String string2 = throwable.getMessage();
        String string3 = Strings.afterLast("$", Strings.afterLast(".", string)) + ": ";
        if (throwable instanceof RethrownException) {
            return string2;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return string3 + string2;
        }
        if (string2 != null) {
            return string3 + string2 + " - " + Debug.describeException(throwable2);
        }
        if (throwable instanceof InvocationTargetException) {
            return Debug.describeException(throwable2);
        }
        return string3 + Debug.describeException(throwable2);
    }

    public static String foldException(Throwable throwable) {
        return Strings.foldLongLine(Debug.describeException(throwable));
    }

    public static void warn(String string) {
        System.err.println("\nWarning: " + string + "\n");
        Thread.dumpStack();
        System.err.println("");
        if (!Parameters.isInteractive()) {
            throw new Warning(string);
        }
        Util.displayAndWait(null, Strings.foldLongLine("Warning: " + string));
    }

    public static void error(String string) {
        System.err.println("\nError: " + string + "\n");
        throw new RuntimeException(string);
    }

    public static synchronized void noteEnumeration(Enumeration enumeration) {
        Debug.note("[");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Debug.note(n + ": " + enumeration.nextElement() + "\n ");
            ++n;
        }
        Debug.noteln("]");
    }

    public static synchronized void noteEnumerationClasses(Enumeration enumeration) {
        Debug.note("[");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Debug.note(n + " " + e.getClass() + ": " + e + "\n ");
            ++n;
        }
        Debug.noteln("]");
    }

    public static void showListDifferences(List list, List list2) {
        int n;
        int n2 = list.size();
        if (n2 > (n = list2.size())) {
            out.println("First list is longer");
        } else if (n > n2) {
            out.println("Second list is longer");
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Object e;
            Object e2 = iterator.next();
            if (e2.equals(e = iterator2.next())) continue;
            out.println(n3 + ": " + e2.getClass() + " " + e2 + " != " + e.getClass() + " " + e);
        }
    }

    public static synchronized void noteElements(Enumeration enumeration, String string) {
        while (enumeration.hasMoreElements()) {
            Debug.noteln(string, enumeration.nextElement());
        }
    }

    public static void expect(boolean bl) {
        if (!bl) {
            Debug.noteln("Assertion failed.");
            throw new AssertionFailure();
        }
    }

    public static void expect(boolean bl, String string) {
        if (!bl) {
            Debug.noteln("Assertion failed:", (Object)string);
            throw new AssertionFailure(string);
        }
    }

    public static void expect(boolean bl, String string, Object object) {
        if (!bl) {
            String string2 = string + " " + object;
            Debug.noteln("Assertion failed:", (Object)string2);
            throw new AssertionFailure(string2);
        }
    }

    public static void expectEquals(Object object, Object object2) {
        if (!object.equals(object2)) {
            String string = "Expected " + object + ", but found " + object2;
            Debug.noteln("Assertion failed:", (Object)string);
            throw new AssertionFailure(string);
        }
    }

    public static void expectEquals(Object object, Object object2, String string) {
        if (!object.equals(object2)) {
            String string2 = string + " Expected " + object + ", but found " + object2;
            Debug.noteln("Assertion failed:", (Object)string2);
            throw new AssertionFailure(string2);
        }
    }

    public static void expectSame(Object object, Object object2) {
        if (object != object2) {
            String string = "Expected " + object + ", but found " + object2;
            Debug.noteln("Assertion failed:", (Object)string);
            throw new AssertionFailure(string);
        }
    }

    public static void expectSame(Object object, Object object2, String string) {
        if (object != object2) {
            String string2 = string + " Expected " + object + ", but found " + object2;
            Debug.noteln("Assertion failed:", (Object)string2);
            throw new AssertionFailure(string2);
        }
    }
}

