/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.SemiPrimitive;
import ix.util.Strings;
import ix.util.Util;
import ix.util.lisp.LList;
import ix.util.lisp.Lisp;
import java.io.Serializable;
import java.util.Date;

public class Duration
implements SemiPrimitive,
Comparable,
Serializable {
    protected long milliseconds;
    protected boolean negative = false;
    protected long days;
    protected int hours;
    protected int minutes;
    protected int seconds;
    protected int ms;
    protected LList isoSequence = Lisp.list(new Character('Y'), new Character('D'), new Character('T'), new Character('H'), new Character('M'), new Character('S'));

    public Duration(Date date, Date date2) {
        this.milliseconds = date2.getTime() - date.getTime();
        this.breakup(this.milliseconds);
    }

    public Duration(long l) {
        this.milliseconds = l;
        this.breakup(this.milliseconds);
    }

    public Duration(long l, int n, int n2, int n3, int n4) {
        this.milliseconds = this.combine(l, n, n2, n3, n4);
        this.breakup(this.milliseconds);
    }

    public Duration(String string) {
        this.parseISOString(string);
    }

    protected void breakup(long l) {
        long l2 = l;
        boolean bl = this.negative = l2 < 0L;
        if (this.negative) {
            l2 = -l2;
        }
        this.ms = (int)(l2 % 1000L);
        this.seconds = (int)((l2 /= 1000L) % 60L);
        this.minutes = (int)((l2 /= 60L) % 60L);
        this.hours = (int)((l2 /= 60L) % 24L);
        this.days = l2 /= 24L;
        Debug.expect(this.hours < 24);
        Debug.expect(this.minutes < 60);
        Debug.expect(this.seconds < 60);
        Debug.expect(this.ms < 1000);
        Debug.expect(this.combine(this.days, this.hours, this.minutes, this.seconds, this.ms) == Math.abs(l));
    }

    protected long combine(long l, int n, int n2, int n3, int n4) {
        long l2 = l * 24L + (long)n;
        l2 = l2 * 60L + (long)n2;
        l2 = l2 * 60L + (long)n3;
        l2 = l2 * 1000L + (long)n4;
        return l2;
    }

    public Duration round(long l) {
        long l2 = this.milliseconds / l;
        long l3 = this.milliseconds % l;
        if (l3 >= l / 2L) {
            ++l2;
        }
        this.milliseconds = l2 * l;
        this.breakup(this.milliseconds);
        return this;
    }

    public Duration roundToSeconds() {
        return this.round(1000L);
    }

    public Duration roundToMinutes() {
        return this.round(60000L);
    }

    public long asMilliseconds() {
        return this.milliseconds;
    }

    public String toISOString() {
        if (this.milliseconds == 0L) {
            return "PT0S";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append("-");
        }
        stringBuffer.append("P");
        if (this.days != 0L) {
            stringBuffer.append(this.days);
            stringBuffer.append("D");
        }
        if (this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.ms == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("T");
        if (this.hours != 0) {
            stringBuffer.append(this.hours);
            stringBuffer.append("H");
        }
        if (this.minutes != 0) {
            stringBuffer.append(this.minutes);
            stringBuffer.append("M");
        }
        if (this.ms != 0) {
            Debug.expect(this.ms < 1000, "ms >= 1000");
            stringBuffer.append(this.seconds);
            stringBuffer.append(".");
            stringBuffer.append(1000 + this.ms);
            stringBuffer.deleteCharAt(stringBuffer.length() - 4);
            stringBuffer.append("S");
        } else if (this.seconds != 0) {
            stringBuffer.append(this.seconds);
            stringBuffer.append("S");
        }
        return stringBuffer.toString();
    }

    protected void parseISOString(String string) {
        RefInt refInt = new RefInt(0);
        boolean bl = false;
        boolean bl2 = false;
        if (string.charAt(0) == '-') {
            this.negative = true;
            ++refInt.i;
        }
        if (string.charAt(refInt.i) == 'P') {
            ++refInt.i;
        } else {
            throw new SyntaxException(string, "does not begin with \"P\".");
        }
        LList lList = LList.newLList(this.isoSequence);
        while (refInt.i < string.length()) {
            char c = string.charAt(refInt.i);
            if (c == 'T') {
                bl = true;
            } else {
                int n = this.scanInt(string, refInt);
                bl2 = true;
                if (refInt.i >= string.length()) {
                    throw new SyntaxException(string, "is missing " + (bl ? "H, M, or S" : "D") + " after " + n);
                }
                c = string.charAt(refInt.i);
                if (c == 'D') {
                    this.days = n;
                } else {
                    if (c == 'H') {
                        this.hours = n;
                    } else if (c == 'M') {
                        this.minutes = n;
                    } else if (c == 'S') {
                        this.seconds = n;
                    } else if (c == '.') {
                        this.seconds = n;
                        ++refInt.i;
                        int n2 = this.scan1000ths(string, refInt);
                        Debug.expect(n2 <= 1000);
                        if (n2 < 1000) {
                            this.ms = n2;
                        } else {
                            ++this.seconds;
                        }
                        if (refInt.i >= string.length() || (c = string.charAt(refInt.i)) != 'S') {
                            throw new SyntaxException(string, "is missing an 'S' after the number of seconds");
                        }
                    } else {
                        throw new SyntaxException(string, "has an invalid character, '" + c + "', ", refInt.i);
                    }
                    if (!bl) {
                        throw new SyntaxException("'" + c + "' is not after 'T' in duration " + Strings.quote(string));
                    }
                }
            }
            Character c2 = new Character(c);
            if (!lList.contains(c2)) {
                throw new SyntaxException(string, "has '" + c + "' out of sequence", refInt.i);
            }
            lList = lList.dropTo(c2).cdr();
            ++refInt.i;
        }
        if (refInt.i < string.length()) {
            throw new SyntaxException(string, "has invalid characters at the end");
        }
        if (!bl2) {
            throw new SyntaxException(string, "does not give a number");
        }
        this.milliseconds = this.combine(this.days, this.hours, this.minutes, this.seconds, this.ms);
    }

    private int scanInt(String string, RefInt refInt) {
        char c;
        int n = 0;
        int n2 = refInt.i;
        while (refInt.i < string.length() && Character.isDigit(c = string.charAt(refInt.i))) {
            n = n * 10 + Character.digit(c, 10);
            ++refInt.i;
        }
        if (refInt.i == n2) {
            throw new SyntaxException(string, "lacks a positive integer", refInt.i);
        }
        return n;
    }

    private int scan1000ths(String string, RefInt refInt) {
        char c;
        int n = 0;
        int n2 = 0;
        int n3 = 100;
        while (n2 < 3 && refInt.i < string.length() && Character.isDigit(c = string.charAt(refInt.i))) {
            Debug.expect(n3 >= 1);
            n += n3 * Character.digit(c, 10);
            n3 /= 10;
            ++n2;
            ++refInt.i;
        }
        if (n2 == 0) {
            throw new SyntaxException(string, "lacks a fraction", refInt.i);
        }
        if (n2 == 3 && Character.isDigit(c = string.charAt(refInt.i))) {
            int n4 = Character.digit(c, 10);
            if (n4 >= 5) {
                ++n;
            }
            do {
                ++refInt.i;
            } while (Character.isDigit(string.charAt(refInt.i)));
        }
        return n;
    }

    public String toString() {
        if (this.milliseconds == 0L) {
            return "0 seconds";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.addValue(stringBuffer, this.days, "day");
        this.addValue(stringBuffer, this.hours, "hour");
        this.addValue(stringBuffer, this.minutes, "minute");
        this.addValue(stringBuffer, this.seconds, "second");
        this.addValue(stringBuffer, this.ms, "millisecond");
        if (this.negative) {
            stringBuffer.insert(0, "negative ");
        }
        return stringBuffer.toString();
    }

    private void addValue(StringBuffer stringBuffer, long l, String string) {
        if (l > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(l).append(" ").append(string);
            if (l > 1L) {
                stringBuffer.append("s");
            }
        }
    }

    public int hashCode() {
        return (int)(this.milliseconds ^ this.milliseconds >> 32);
    }

    public boolean equals(Object object) {
        return this.asMilliseconds() == ((Duration)object).asMilliseconds();
    }

    public int compareTo(Object object) {
        long l = this.asMilliseconds() - ((Duration)object).asMilliseconds();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    public static void main(String[] stringArray) {
        System.out.println(new Duration(10L, 23, 0, 59, 12).toISOString());
        System.out.println(new Duration(10L, 23, 0, 59, 12));
        System.out.println(new Duration(10L, 23, 0, 59, 12).roundToMinutes());
        System.out.println(new Duration(10L, 23, 0, 30, 0).roundToMinutes());
        System.out.println(new Duration(10L, 23, 0, 29, 500).roundToMinutes());
        System.out.println(new Duration(10L, 23, 0, 29, 500).roundToSeconds());
        System.out.println("max long -> " + new Duration(Long.MAX_VALUE));
        Duration duration = new Duration(10L, 23, 0, 59, 12);
        Debug.expect(duration.asMilliseconds() == new Duration(duration.asMilliseconds()).asMilliseconds());
        Duration duration2 = new Duration(-duration.asMilliseconds());
        System.out.println(duration2);
        Debug.expect(duration2.asMilliseconds() == new Duration(duration2.asMilliseconds()).asMilliseconds());
        duration = new Duration("P1D");
        Debug.expectEquals(duration, new Duration(duration.asMilliseconds()));
        Debug.expectEquals(duration, new Duration(duration.toISOString()));
        Debug.expect(duration.compareTo(new Duration(duration.toISOString())) == 0);
        Debug.expect(new Duration("P0DT").compareTo(new Duration("P35DT")) <= 0);
        while (true) {
            String string = Util.askLine("Duration: ");
            try {
                Duration duration3 = new Duration(string);
                System.out.println(duration3.toISOString() + " = " + duration3.toString());
                Duration duration4 = new Duration(duration3.asMilliseconds());
                System.out.println(duration4.toISOString() + " = " + duration4.toString());
                System.out.println("Milliseconds = " + duration3.asMilliseconds() + ", " + duration4.asMilliseconds());
                continue;
            }
            catch (Throwable throwable) {
                Debug.noteException(throwable, false);
                continue;
            }
            break;
        }
    }

    private class RefInt {
        int i;

        RefInt(int n) {
            this.i = n;
        }
    }

    public static class SyntaxException
    extends RuntimeException {
        SyntaxException(String string, String string2, int n) {
            this(string, string2 + " at position " + n);
        }

        SyntaxException(String string, String string2) {
            this("Duration \"" + string + "\" " + string2);
        }

        SyntaxException(String string) {
            super(string);
        }
    }
}

