/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.DirectedGraph;
import ix.util.Function1;
import ix.util.StableHashMap;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class FanComposer {
    protected Collection keys;
    protected LListCollector allFans = new LListCollector();
    protected Map result = null;

    public FanComposer(Collection collection) {
        this.keys = collection;
    }

    public void apply(Map map) {
        this.allFans.add(map);
        this.result = null;
    }

    public void apply(DirectedGraph directedGraph) {
        this.allFans.add(directedGraph);
        this.result = null;
    }

    public void apply(Function1 function1) {
        this.allFans.add(function1);
        this.result = null;
    }

    public Map getResultMap() {
        if (this.result == null) {
            this.computeResult();
        }
        return this.result;
    }

    private void computeResult() {
        this.result = this.makeResultMap();
        for (Object e : this.keys) {
            Collection collection = this.makeValueCollection();
            this.applyFans(e, collection, this.allFans.contents());
            this.result.put(e, collection);
        }
        this.allFans.clear();
        this.allFans.add(this.result);
    }

    private void applyFans(Object object, Collection collection, LList lList) {
        Object object2 = lList.car();
        Collection collection2 = object2 instanceof Map ? (Collection)((Map)object2).get(object) : (object2 instanceof DirectedGraph ? ((DirectedGraph)object2).getSuccessors(object) : (Collection)((Function1)object2).funcall(object));
        if ((lList = lList.cdr()).isEmpty()) {
            collection.addAll(collection2);
        } else {
            for (Object e : collection2) {
                this.applyFans(e, collection, lList);
            }
        }
    }

    protected Map makeResultMap() {
        return new StableHashMap();
    }

    protected Collection makeValueCollection() {
        return new HashSet();
    }
}

