/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFileFilter
extends FileFilter {
    protected Collection allowed;
    protected String description = null;
    private boolean acceptDirs = true;
    private boolean caseSensitive = true;

    public FileExtensionFileFilter(String string) {
        this.allowed = new LinkedList();
        this.allowed.add(string);
    }

    public FileExtensionFileFilter(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.allowed = collection;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setAcceptDirectories(boolean bl) {
        this.acceptDirs = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description == null ? "file extensions: " + this.toString() : this.description + "(" + this.toString() + ")";
    }

    public boolean accept(File file) {
        if (this.acceptDirs && file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        string = string.substring(string.lastIndexOf(46) + 1);
        Iterator iterator = this.allowed.iterator();
        while (iterator.hasNext()) {
            if (!(this.caseSensitive ? iterator.next().equals(string) : string.compareToIgnoreCase((String)iterator.next()) == 0)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Iterator iterator = this.allowed.iterator();
        String string = this.getStarDotString((String)iterator.next());
        while (iterator.hasNext()) {
            string = string + ", " + this.getStarDotString((String)iterator.next());
        }
        return string;
    }

    private String getStarDotString(String string) {
        return "*." + (this.caseSensitive ? string : string.toLowerCase());
    }
}

