/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ISODateFormat {
    final String dateTimePattern = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";
    final SimpleDateFormat format = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");

    public ISODateFormat() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format.setLenient(false);
    }

    public String formatDateTime(Date date) {
        return this.format.format(date);
    }

    public Date parseDateTime(String string) {
        try {
            return this.format.parse(string);
        }
        catch (ParseException parseException) {
            Debug.noteException(parseException);
            throw new IllegalArgumentException("Invalid ISO 8601 date-time string: " + Strings.quote(string));
        }
    }
}

