/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ConsistencyException;
import ix.util.Strings;
import java.util.List;

public class MinMax {
    private long min;
    private long max;

    public MinMax(long l, long l2) {
        this.min = l;
        this.max = l2;
        this.checkRange();
    }

    public MinMax(String string) {
        List<String> list = Strings.breakAt("..", string);
        if (list.size() != 2) {
            throw new IllegalArgumentException("Invalid MinMax spec: " + string);
        }
        this.min = Long.valueOf(list.get(0));
        this.max = Long.valueOf(list.get(1));
        this.checkRange();
    }

    private void checkRange() {
        if (this.min > this.max) {
            throw new ConsistencyException("Min " + this.min + " is not <= max " + this.max);
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public String toString() {
        return "MinMax[" + this.min + ".." + this.max + "]";
    }
}

