/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ObjectComparator
implements Comparator {
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof Symbol || object2 instanceof Symbol) {
            return this.compareSymbol(object, object2);
        }
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).compareTo((String)object2);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return this.compareNumbers((Number)object, (Number)object2);
        }
        if (object instanceof List && object2 instanceof List) {
            return this.compareLists((List)object, (List)object2);
        }
        if (object instanceof Comparable && object2 instanceof Comparable) {
            return this.compareComparable((Comparable)object, (Comparable)object2);
        }
        return this.defaultCompare(object, object2);
    }

    protected int compareSymbol(Object object, Object object2) {
        if (object instanceof Symbol) {
            if (object2 instanceof Symbol) {
                return object.toString().compareTo(object2.toString());
            }
            if (object2 instanceof String) {
                int n = object.toString().compareTo((String)object2);
                return n == 0 ? -1 : n;
            }
            return this.defaultCompare(object, object2);
        }
        Debug.expect(object2 instanceof Symbol, "not a Symbol", object2);
        return -this.compareSymbol(object2, object);
    }

    protected int compareNumbers(Number number, Number number2) {
        double d;
        double d2 = number.doubleValue();
        if (d2 < (d = number2.doubleValue())) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    protected int compareLists(List list, List list2) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator2.hasNext()) {
                int n = this.compare(iterator.next(), iterator2.next());
                if (n == 0) continue;
                return n;
            }
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected int compareComparable(Comparable comparable, Comparable comparable2) {
        try {
            if (comparable.getClass().isInstance(comparable2)) {
                return comparable.compareTo(comparable2);
            }
            if (comparable2.getClass().isInstance(comparable)) {
                return -comparable2.compareTo(comparable);
            }
        }
        catch (ClassCastException classCastException) {
            Debug.noteException(classCastException);
        }
        return this.defaultCompare(comparable, comparable2);
    }

    protected int defaultCompare(Object object, Object object2) {
        return Lisp.printToString(object).compareTo(Lisp.printToString(object2));
    }
}

