/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.Predicate1;
import ix.util.RethrownException;
import ix.util.ThrownResult;
import ix.util.Util;
import ix.util.lisp.Lisp;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.reflect.ObjectVisitor;
import ix.util.xml.LiteralDocument;
import ix.util.xml.XML;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectWalker
implements ObjectVisitor {
    protected ClassSyntax syntax;

    public ObjectWalker() {
        this(XML.config().defaultClassSyntax());
    }

    public ObjectWalker(ClassSyntax classSyntax) {
        this.syntax = classSyntax;
    }

    public static Object findIf(Object object, final Predicate1 predicate1) {
        ObjectWalker objectWalker = new ObjectWalker(){

            public void walk(Object object) {
                if (predicate1.trueOf(object)) {
                    throw new ThrownResult(object);
                }
                super.walk(object);
            }
        };
        try {
            objectWalker.walk(object);
        }
        catch (ThrownResult thrownResult) {
            return thrownResult.getResult();
        }
        return null;
    }

    public static Collection collectIf(Object object, Predicate1 predicate1) {
        return ObjectWalker.collectIf(object, new HashSet(), predicate1);
    }

    public static Collection collectIf(Object object, final Collection collection, final Predicate1 predicate1) {
        ObjectWalker objectWalker = new ObjectWalker(){

            public void walk(Object object) {
                if (predicate1.trueOf(object)) {
                    collection.add(object);
                }
                super.walk(object);
            }
        };
        objectWalker.walk(object);
        return collection;
    }

    public void walk(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        ClassDescr classDescr = this.syntax.getClassDescr(clazz);
        classDescr.visitObject(object, this);
    }

    public void visitElement(Object object) {
        this.walk(object);
    }

    public void visitPrimitive(Object object, ClassDescr classDescr) {
    }

    public void visitStruct(Object object, ClassDescr classDescr) {
        List<FieldDescr> list = classDescr.getFieldDescrs();
        for (FieldDescr fieldDescr : list) {
            Object object2;
            try {
                object2 = fieldDescr.getValue(object);
            }
            catch (Exception exception) {
                Debug.noteException(exception);
                throw new RethrownException(exception);
            }
            this.visitElement(object2);
        }
    }

    public void visitXML(LiteralDocument literalDocument, ClassDescr classDescr) {
    }

    public void visitList(List list, ClassDescr classDescr) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.visitElement(iterator.next());
        }
    }

    public void visitSet(Set set, ClassDescr classDescr) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.visitElement(iterator.next());
        }
    }

    public void visitMap(Map map, ClassDescr classDescr) {
        for (Map.Entry entry : map.entrySet()) {
            this.visitElement(entry.getKey());
            this.visitElement(entry.getValue());
        }
    }

    public static void main(String[] stringArray) {
        ObjectWalker objectWalker = new ObjectWalker(){

            public void visitElement(Object object) {
                Debug.noteln("Visiting", object);
                this.walk(object);
            }
        };
        String string;
        while (!(string = Util.askLine("Object:")).equals("bye")) {
            Object object = Lisp.readFromString(string);
            objectWalker.walk(object);
        }
        return;
    }
}

