/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.RethrownIOException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.WithCleanup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyLogger {
    private String logFileName;
    private Map<String, LoggingMap> propNameToObjectValueMap = new LinkedHashMap<String, LoggingMap>();
    private Writer logWriter = null;

    public PropertyLogger(String string) {
        this.logFileName = string;
    }

    public LoggingMap getMap(String string) {
        return this.propNameToObjectValueMap.get(string);
    }

    public LoggingMap ensureMap(String string) {
        LoggingMap loggingMap = this.getMap(string);
        if (loggingMap == null) {
            loggingMap = new LoggingMap(string);
            this.propNameToObjectValueMap.put(string, loggingMap);
        }
        return loggingMap;
    }

    public String get(String string, String string2) {
        LoggingMap loggingMap = this.getMap(string);
        return loggingMap != null ? this.getMap(string).get(string2) : null;
    }

    public void put(String string, String string2, String string3) {
        try {
            if (this.logWriter == null) {
                this.openLogFile();
            }
            this.logProp(string, string2, string3);
            this.logWriter.flush();
        }
        catch (IOException iOException) {
            throw new RethrownIOException(iOException);
        }
        this.ensureMap(string).__record(string2, string3);
    }

    public boolean putIfNew(String string, String string2, String string3) {
        return this.ensureMap(string).putIfNew(string2, string3);
    }

    public void readLogIfExists() {
        try {
            File file = new File(this.logFileName);
            if (file.exists()) {
                Debug.noteln("Reading propert values from", (Object)this.logFileName);
                final BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                Util.run(new WithCleanup(){

                    public void body() throws IOException {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            PropertyLogger.this.readProp(string);
                        }
                    }

                    public void cleanup() throws IOException {
                        bufferedReader.close();
                    }
                });
            }
        }
        catch (IOException iOException) {
            throw new RethrownIOException(iOException);
        }
    }

    private void readProp(String string) {
        List<String> list = Strings.breakAtAny("()=", string);
        if (list.size() != 4 || !list.get(2).equals("")) {
            throw new IllegalArgumentException("Systax error in property line: " + string);
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        String string4 = list.get(3);
        Debug.noteln("Property: " + string2 + "(" + string3 + ")=" + string4);
        this.ensureMap(string2).__record(string3, string4);
    }

    private void logProp(String string, String string2, String string3) throws IOException {
        this.logWriter.write(string + "(" + string2 + ")=" + string3 + "\n");
    }

    private void openLogFile() throws IOException {
        File file = new File(this.logFileName);
        if (file.exists()) {
            Util.renameToBackup(file);
        }
        this.logWriter = new FileWriter(file);
        for (Map.Entry<String, LoggingMap> entry : this.propNameToObjectValueMap.entrySet()) {
            String string = entry.getKey();
            LoggingMap loggingMap = entry.getValue();
            for (Map.Entry entry2 : loggingMap.__entrySet()) {
                this.logProp(string, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = stringArray[0];
        PropertyLogger propertyLogger = new PropertyLogger(string2);
        propertyLogger.readLogIfExists();
        while (!(string = Util.askLine("prop object value:")).equals("bye")) {
            List<String> list = Strings.breakAt(" ", string);
            if (list.size() == 3) {
                if (propertyLogger.putIfNew(list.get(0), list.get(1), list.get(2))) {
                    System.out.println("Thanks.  That was new.");
                    continue;
                }
                System.out.println("I knew that.");
                continue;
            }
            System.out.println("Syntax error");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LoggingMap {
        private Map<String, String> map = new LinkedHashMap<String, String>();
        private String propName;

        protected LoggingMap(String string) {
            this.propName = string;
        }

        public String get(String string) {
            return this.map.get(string);
        }

        public void put(String string, String string2) {
            PropertyLogger.this.put(this.propName, string, string2);
        }

        public boolean putIfNew(String string, String string2) {
            String string3 = this.map.get(string);
            if (string3 != null && string3.equals(string2)) {
                return false;
            }
            this.put(string, string2);
            return true;
        }

        private void __record(String string, String string2) {
            this.map.put(string, string2);
        }

        private Set<Map.Entry<String, String>> __entrySet() {
            return this.map.entrySet();
        }

        public Set<Map.Entry<String, String>> entrySet() {
            return Collections.unmodifiableMap(this.map).entrySet();
        }

        public String toString() {
            return "LoggingMap[" + this.propName + "]";
        }
    }
}

