/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.Debug;
import ix.util.SemiPrimitive;
import ix.util.reflect.ClassDescr;
import ix.util.reflect.ClassSyntax;
import ix.util.reflect.FieldDescr;
import ix.util.xml.XML;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructuralEquality {
    protected ClassSyntax syntax;

    public StructuralEquality() {
        this(XML.config().defaultClassSyntax());
    }

    public StructuralEquality(ClassSyntax classSyntax) {
        this.syntax = classSyntax;
    }

    public boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object.getClass() != object2.getClass() && !this.haveEquivalentClasses(object, object2)) {
            return false;
        }
        if (object instanceof String) {
            return object.equals(object2);
        }
        if (object instanceof Number) {
            if (object instanceof Comparable) {
                return ((Comparable)object).compareTo(object2) == 0;
            }
            throw new IncomparableException(object, object2);
        }
        if (object instanceof List) {
            return this.equalLists((List)object, (List)object2);
        }
        if (object instanceof Set) {
            return this.equalSets((Set)object, (Set)object2);
        }
        if (object instanceof Map) {
            return this.equalMaps((Map)object, (Map)object2);
        }
        if (object instanceof SemiPrimitive) {
            return object.equals(object2);
        }
        ClassDescr classDescr = this.syntax.getClassDescr(object.getClass());
        if (classDescr.isStruct()) {
            return this.equalStructs(object, object2, classDescr);
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2) == 0;
        }
        if (object instanceof Boolean) {
            return object.equals(object2);
        }
        return object == object2;
    }

    protected boolean haveEquivalentClasses(Object object, Object object2) {
        return object.getClass() == object2.getClass();
    }

    protected boolean equalLists(List list, List list2) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (this.equal(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    protected boolean equalSets(Set set, Set set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        LinkedList linkedList = new LinkedList(set2);
        block0: for (Object e : set) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (!this.equal(e, iterator.next())) continue;
                iterator.remove();
                continue block0;
            }
            return false;
        }
        Debug.expect(linkedList.isEmpty());
        return true;
    }

    protected boolean equalMaps(Map map, Map map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        LinkedList linkedList = new LinkedList(map2.entrySet());
        block0: for (Map.Entry entry : map.entrySet()) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator.next();
                if (!this.equal(entry.getKey(), entry2.getKey()) || !this.equal(entry.getValue(), entry2.getValue())) continue;
                iterator.remove();
                continue block0;
            }
            return false;
        }
        Debug.expect(linkedList.isEmpty());
        return true;
    }

    protected boolean equalStructs(Object object, Object object2, ClassDescr classDescr) {
        List<FieldDescr> list = classDescr.getFieldDescrs();
        try {
            for (FieldDescr fieldDescr : list) {
                Object object3 = fieldDescr.getValue(object);
                Object object4 = fieldDescr.getValue(object2);
                if (object3 == null && object4 == null || !(object3 == null || object4 == null ? !this.missingFieldIsOk(classDescr, fieldDescr, object3, object4) : !this.equal(object3, object4))) continue;
                return false;
            }
            return true;
        }
        catch (IncomparableException incomparableException) {
            throw incomparableException;
        }
        catch (Exception exception) {
            throw new IncomparableException(object, object2, exception);
        }
    }

    protected boolean missingFieldIsOk(ClassDescr classDescr, FieldDescr fieldDescr, Object object, Object object2) {
        return false;
    }

    public static class IncomparableException
    extends IllegalArgumentException {
        public IncomparableException(Object object, Object object2) {
            this(object, object2, null);
        }

        public IncomparableException(Object object, Object object2, Throwable throwable) {
            super("Cannot compare " + object.getClass().toString() + " instances 1: " + object + " and 2: " + object2 + (throwable == null ? "" : " because " + throwable), throwable);
        }
    }
}

