/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.Debug;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.context.ContextHolder;
import ix.util.context.ContextHoldingStrategy;
import ix.util.context.ContextLink;
import ix.util.context.GlobalHoldingStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context {
    static long count = 0L;
    static HashMap numberToContextTable = new HashMap();
    public static final Context rootContext = new Context();
    static ContextHoldingStrategy contextHoldingStrategy = new GlobalHoldingStrategy();
    private static volatile boolean haveSetStrategyFromParameter = false;
    final long number;
    final Context parent;
    final List<Context> children = new ArrayList<Context>();

    public Context() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context(Context context) {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            this.number = count++;
            this.parent = context == null && rootContext != null ? rootContext : context;
            if (this.parent != null) {
                this.parent.children.add(this);
            }
            numberToContextTable.put(new Long(this.number), new WeakReference<Context>(this));
            Debug.expect(Context.getContext(this.number) == this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public long getNumber() {
        return this.number;
    }

    public Context getParent() {
        return this.parent;
    }

    public List<Context> getAncestors() {
        LinkedList<Context> linkedList = new LinkedList<Context>();
        Context context = this;
        while (context != null) {
            linkedList.add(context);
            context = context.parent;
        }
        return linkedList;
    }

    public List<Context> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
            Context.discardSubtree(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void discardSubtree(Context context) {
        for (Context object2 : context.children) {
            Context.discardSubtree(object2);
        }
        context.children.clear();
        Long l = new Long(context.number);
        WeakReference weakReference = (WeakReference)numberToContextTable.get(l);
        weakReference.clear();
        numberToContextTable.remove(l);
        Debug.expect(Context.getContext(context.number) == null);
    }

    public String toString() {
        return "#<Context " + this.number + ">";
    }

    public static Context getContext() {
        return contextHoldingStrategy.getContextHolder().getContext();
    }

    public static Context getContext(long l) {
        WeakReference weakReference = (WeakReference)numberToContextTable.get(new Long(l));
        return weakReference == null ? null : (Context)weakReference.get();
    }

    public static void setContext(Context context) {
        contextHoldingStrategy.getContextHolder().setContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearContexts() {
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            Context.rootContext.children.clear();
            numberToContextTable.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            contextHoldingStrategy.clearContexts();
            return;
        }
    }

    public static ContextHoldingStrategy getContextHoldingStrategy() {
        return contextHoldingStrategy;
    }

    public static void setContextHoldingStrategy(ContextHoldingStrategy contextHoldingStrategy) {
        Debug.noteln("Setting context holding strategy to", (Object)contextHoldingStrategy);
        Context.contextHoldingStrategy = contextHoldingStrategy;
    }

    public static ContextHolder getContextHolder() {
        return contextHoldingStrategy.getContextHolder();
    }

    public static <T> T getInContext(ContextLink<T> contextLink, Context context) {
        Context context2 = context;
        while (context2 != null) {
            long l = context2.number;
            while (contextLink != null && contextLink.contextNumber > l) {
                contextLink = contextLink.next;
            }
            if (contextLink == null) {
                return null;
            }
            if (contextLink.contextNumber == l) {
                return contextLink.value;
            }
            context2 = context2.parent;
        }
        return null;
    }

    public static <T> T getInContext(ContextLink<T> contextLink, Context context, T t) {
        ContextLink<T> contextLink2 = Context.getValueLinkInContext(contextLink, context);
        if (contextLink2 == null) {
            return t;
        }
        return contextLink2.value;
    }

    public static <T> ContextLink<T> getValueLinkInContext(ContextLink<T> contextLink, Context context) {
        Context context2 = context;
        while (context2 != null) {
            long l = context2.number;
            while (contextLink != null && contextLink.contextNumber > l) {
                contextLink = contextLink.next;
            }
            if (contextLink == null) {
                return null;
            }
            if (contextLink.contextNumber == l) {
                return contextLink;
            }
            context2 = context2.parent;
        }
        return null;
    }

    public static <T> void setInContext(ContextLink<T> contextLink, Context context, T t) {
        Context context2 = context;
        long l = context2.number;
        ContextLink contextLink2 = contextLink;
        while (true) {
            if (contextLink2.contextNumber == l) {
                contextLink2.value = t;
                return;
            }
            if (contextLink2.contextNumber < l) {
                contextLink2.next = new ContextLink(contextLink2.contextNumber, contextLink2.value, contextLink2.next);
                contextLink2.contextNumber = l;
                contextLink2.value = t;
                return;
            }
            if (contextLink2.next == null) {
                contextLink2.next = new ContextLink<T>(context2, t, null);
                return;
            }
            contextLink2 = contextLink2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inContext(ContextHolder contextHolder, Context context, Runnable runnable) {
        Context context2 = contextHolder.getContext();
        try {
            contextHolder.setContext(context);
            runnable.run();
        }
        finally {
            contextHolder.setContext(context2);
        }
    }

    public static Context pushContext(ContextHolder contextHolder) {
        contextHolder.setContext(new Context(contextHolder.getContext()));
        return contextHolder.getContext();
    }

    public static Context popContext(ContextHolder contextHolder) {
        Context context = contextHolder.getContext();
        if (context == null) {
            throw new Error("Trying to pop null context");
        }
        if (context.parent == null) {
            throw new Error("Trying to pop to null context");
        }
        contextHolder.setContext(context.parent);
        return context;
    }

    public static Context pushContext() {
        return Context.pushContext(contextHoldingStrategy.getContextHolder());
    }

    public static Context popContext() {
        return Context.popContext(contextHoldingStrategy.getContextHolder());
    }

    public static void inContext(Context context, Runnable runnable) {
        Context.inContext(contextHoldingStrategy.getContextHolder(), context, runnable);
    }

    public static synchronized void printContextTree() {
        Debug.noteln("Context tree:");
        Context.pctLoop(rootContext, 0);
    }

    private static void pctLoop(Context context, int n) {
        Debug.out.print(Strings.repeat(n, "   "));
        Debug.out.println(context);
        for (Context context2 : context.getChildren()) {
            Context.pctLoop(context2, n + 1);
        }
    }

    static {
        if (!haveSetStrategyFromParameter) {
            haveSetStrategyFromParameter = true;
            String string = Parameters.getParameter("context-holding-strategy");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    ContextHoldingStrategy contextHoldingStrategy = (ContextHoldingStrategy)Util.makeInstance(clazz);
                    Context.setContextHoldingStrategy(contextHoldingStrategy);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RethrownException(classNotFoundException, "Can't find context holding strategy class " + string);
                }
            }
        }
    }
}

