/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.context.Context;
import ix.util.context.ContextChangeException;
import ix.util.context.ContextHolder;
import ix.util.context.ContextLink;
import ix.util.context.ContextMap;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextHashMap<K, V>
extends AbstractMap<K, V>
implements ContextMap<K, V> {
    protected static final Object UNDEF = new Object();
    protected ContextHolder holder;
    protected HashMap map;
    protected Entry keyChain;
    protected Entry keyChainLast;

    public ContextHashMap() {
        this(Context.getContextHolder());
    }

    public ContextHashMap(int n) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = Context.getContextHolder();
        this.map = new HashMap(n);
    }

    public ContextHashMap(int n, float f) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = Context.getContextHolder();
        this.map = new HashMap(n, f);
    }

    public ContextHashMap(Map map) {
        this(Context.getContextHolder(), map);
    }

    public ContextHashMap(ContextHolder contextHolder) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = contextHolder;
        this.map = new HashMap();
    }

    public ContextHashMap(ContextHolder contextHolder, final Map map) {
        this.keyChainLast = this.keyChain = new Entry(null, null);
        this.holder = contextHolder;
        this.map = new HashMap();
        Context.inContext(contextHolder, Context.rootContext, new Runnable(){

            public void run() {
                ContextHashMap.this.putAll(map);
            }
        });
    }

    @Override
    public V put(K k, V v) {
        return this._put(k, v);
    }

    private V _put(K k, Object object) {
        Entry entry = (Entry)this.map.get(k);
        Context context = this.holder.getContext();
        if (entry == null) {
            Entry entry2 = new Entry(k, new ContextLink<Object>(context, object));
            entry2.linkAfter(this.keyChainLast);
            this.keyChainLast = entry2;
            this.map.put(k, entry2);
            return null;
        }
        ContextLink contextLink = entry.valLink;
        Object t = Context.getInContext(contextLink, context);
        Context.setInContext(contextLink, context, object);
        return t == UNDEF ? null : (V)t;
    }

    @Override
    public V get(Object object) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            return null;
        }
        ContextLink contextLink = entry.valLink;
        Object t = Context.getInContext(contextLink, this.holder.getContext());
        return t == UNDEF ? null : (V)t;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this.keyChain);
    }

    @Override
    public boolean containsKey(Object object) {
        Entry entry = (Entry)this.map.get(object);
        if (entry == null) {
            return false;
        }
        ContextLink contextLink = Context.getValueLinkInContext(entry.valLink, this.holder.getContext());
        return contextLink != null && contextLink.value != UNDEF;
    }

    @Override
    public void clearCompletely() {
        this.map.clear();
        this.keyChainLast = this.keyChain = new Entry(null, null);
    }

    @Override
    public V remove(Object object) {
        if (this.map.get(object) != null) {
            return this._put(object, UNDEF);
        }
        return null;
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().setValue(UNDEF);
        }
    }

    protected static class IteratorContextException
    extends ContextChangeException {
        IteratorContextException(Context context, Context context2) {
            super("The iterator for a ContextHashMap entry-set created in " + context + " was used in " + context2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        Context setCreationContext;
        Entry chain;
        Entry next = null;

        EntrySetIterator(Entry entry, Context context) {
            Debug.expect(entry != null);
            this.chain = entry;
            this.setCreationContext = context;
            this.findNext();
        }

        private void findNext() {
            Context context = ContextHashMap.this.holder.getContext();
            if (context != this.setCreationContext) {
                throw new IteratorContextException(this.setCreationContext, context);
            }
            while ((this.next = this.chain.getNext()) != null) {
                this.chain = this.next;
                ContextLink contextLink = Context.getValueLinkInContext(this.next.valLink, context);
                if (contextLink == null || contextLink.value == UNDEF) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new ConsistencyException("next is null");
            }
            Entry entry = this.next;
            this.findNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this + " does not support remove()");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Context creationContext;
        Entry chain;
        int size = -1;

        EntrySet(Entry entry) {
            this.chain = entry;
            this.creationContext = ContextHashMap.this.holder.getContext();
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = this.calcSize();
            }
            return this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.chain, this.creationContext);
        }

        protected int calcSize() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Entry
    implements Map.Entry<K, V> {
        K key;
        ContextLink valLink;
        Entry nextEntry = null;

        Entry(K k, ContextLink contextLink) {
            this.key = k;
            this.valLink = contextLink;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            Object t = Context.getInContext(this.valLink, ContextHashMap.this.holder.getContext());
            if (t == UNDEF) {
                throw new IllegalStateException("getValue() on Map.Entry for " + this.key);
            }
            return t;
        }

        @Override
        public V setValue(V v) {
            return ContextHashMap.this.put(this.key, v);
        }

        Entry getNext() {
            return this.nextEntry;
        }

        void linkAfter(Entry entry) {
            Debug.expect(entry.nextEntry == null, "pre already linked");
            Debug.expect(this.nextEntry == null, "this already linked");
            entry.nextEntry = this;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object k2 = this.key;
            Object v2 = this.getValue();
            return (k2 == null ? k == null : k2.equals(k)) && (v2 == null ? v == null : v2.equals(v));
        }

        @Override
        public int hashCode() {
            Object k = this.key;
            Object v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return "CtxtMapEntry[" + this.getKey() + "-->" + this.getValue() + "]";
        }
    }
}

