/*
 * Decompiled with CFR 0.152.
 */
package ix.util.context;

import ix.util.context.Context;
import ix.util.context.ContextHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextLockingProxy {
    private ContextLockingProxy() {
    }

    public static <T> T newProxyInstance(Class<T> clazz, Object object) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new Handler(object));
    }

    public static class Handler
    implements InvocationHandler {
        protected Object instance;
        protected Context instanceContext = Context.getContext();

        public Handler(Object object) {
            this.instance = object;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            ContextHolder contextHolder;
            ContextHolder contextHolder2 = contextHolder = Context.getContextHolder();
            synchronized (contextHolder2) {
                Context context = contextHolder.getContext();
                try {
                    contextHolder.setContext(this.instanceContext);
                    Object object2 = method.invoke(this.instance, objectArray);
                    return object2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                finally {
                    this.instanceContext = contextHolder.getContext();
                    contextHolder.setContext(context);
                }
            }
        }
    }
}

